/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataFlavor
implements Externalizable,
Cloneable {
    static final long serialVersionUID = 8367026044764648243L;
    public static final DataFlavor plainTextFlavor = new DataFlavor(Class.forName("java.io.InputStream"), "text/plain; charset=unicode", "plain unicode text");
    public static final DataFlavor stringFlavor = new DataFlavor(Class.forName("java.lang.String"), "Java Unicode String");
    public static final DataFlavor javaFileListFlavor = new DataFlavor(Class.forName("java.util.List"), "Java File List");
    public static final DataFlavor imageFlavor = new DataFlavor(Class.forName("java.awt.Image"), "Java Image");
    public static final String javaSerializedObjectMimeType = "application/x-java-serialized-object";
    public static final String javaJVMLocalObjectMimeType = "application/x-java-jvm-local-object";
    public static final String javaRemoteObjectMimeType = "application/x-java-remote-object";
    private final String mimeType;
    private final Class representationClass;
    private String humanPresentableName;

    protected static final Class tryToLoadClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            return Class.forName(string);
        }
        catch (Exception exception) {
            if (classLoader != null) {
                return classLoader.loadClass(string);
            }
            throw new ClassNotFoundException(string);
        }
    }

    public DataFlavor() {
        this.mimeType = null;
        this.representationClass = null;
        this.humanPresentableName = null;
    }

    private DataFlavor(Class clazz, String string, String string2) {
        this.representationClass = clazz;
        this.mimeType = string;
        if (string2 != null) {
            this.humanPresentableName = string2;
            return;
        }
        this.humanPresentableName = string;
    }

    public DataFlavor(Class clazz, String string) {
        this(clazz, new StringBuffer().append("application/x-java-serialized-object; class=").append(clazz.getName()).toString(), string);
    }

    public DataFlavor(String string, String string2, ClassLoader classLoader) throws ClassNotFoundException {
        this(DataFlavor.getRepresentationClassFromMime(string, classLoader), string, string2);
    }

    private static Class getRepresentationClassFromMime(String string, ClassLoader classLoader) {
        String string2 = DataFlavor.getParameter("class", string);
        if (string2 != null) {
            try {
                return DataFlavor.tryToLoadClass(string2, classLoader);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(new StringBuffer().append("classname: ").append(exception.getMessage()).toString());
            }
        }
        return Class.forName("java.io.InputStream");
    }

    public DataFlavor(String string, String string2) {
        this(DataFlavor.getRepresentationClassFromMime(string, null), string2);
    }

    public DataFlavor(String string) throws ClassNotFoundException {
        this(string, null);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Class getRepresentationClass() {
        return this.representationClass;
    }

    public String getHumanPresentableName() {
        return this.humanPresentableName;
    }

    public String getPrimaryType() {
        int n = this.mimeType.indexOf("/");
        if (n == -1) {
            return this.mimeType;
        }
        return this.mimeType.substring(0, n);
    }

    public String getSubType() {
        int n = this.mimeType.indexOf("/");
        if (n == -1) {
            return "";
        }
        String string = this.mimeType.substring(n + 1);
        if ((n = string.indexOf(" ")) == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    private static String getParameter(String string, String string2) {
        int n = string2.indexOf(new StringBuffer().append(string).append("=").toString());
        if (n == -1) {
            return null;
        }
        String string3 = string2.substring(n + string.length() + 2);
        if ((n = string3.indexOf(" ")) == -1) {
            return string3;
        }
        return string3.substring(0, n);
    }

    public String getParameter(String string) {
        return DataFlavor.getParameter(string, this.mimeType);
    }

    public void setHumanPresentableName(String string) {
        this.humanPresentableName = string;
    }

    public boolean isMimeTypeEqual(String string) {
        return this.mimeType.equals(string);
    }

    public boolean isMimeTypeEqual(DataFlavor dataFlavor) {
        return this.isMimeTypeEqual(dataFlavor.getMimeType());
    }

    public boolean isMimeTypeSerializedObject() {
        return this.mimeType.startsWith(javaSerializedObjectMimeType);
    }

    public boolean isRepresentationClassInputStream() {
        return this.representationClass.getName().equals("java.io.InputStream");
    }

    public boolean isRepresentationClassSerializable() {
        Class[] classArray = this.representationClass.getInterfaces();
        int n = 0;
        while (n < classArray.length) {
            if (classArray[n].getName().equals("java.io.Serializable")) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isRepresentationClassRemote() {
        throw new RuntimeException("Not implemented");
    }

    public boolean isFlavorSerializedObjectType() {
        return this.mimeType.startsWith(javaSerializedObjectMimeType);
    }

    public boolean isFlavorRemoteObjectType() {
        return this.mimeType.startsWith(javaRemoteObjectMimeType);
    }

    public boolean isFlavorJavaFileListType() {
        return this.mimeType.equals(DataFlavor.javaFileListFlavor.mimeType) && this.representationClass.equals(DataFlavor.javaFileListFlavor.representationClass);
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean equals(DataFlavor dataFlavor) {
        if (dataFlavor == null) {
            return false;
        }
        if (!this.mimeType.toLowerCase().equals(dataFlavor.mimeType.toLowerCase())) {
            return false;
        }
        return this.representationClass.equals(dataFlavor.representationClass);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof DataFlavor)) {
            return false;
        }
        return this.equals((DataFlavor)object);
    }

    public boolean equals(String string) {
        return this.isMimeTypeEqual(string);
    }

    public int hashCode() {
        return this.mimeType.toLowerCase().hashCode() ^ this.representationClass.hashCode();
    }

    public boolean match(DataFlavor dataFlavor) {
        return this.equals(dataFlavor);
    }

    protected String normalizeMimeTypeParameter(String string, String string2) {
        return new StringBuffer().append(string).append("=").append(string2).toString();
    }

    protected String normalizeMimeType(String string) {
        return string;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
    }

    public String toString() {
        return new StringBuffer().append("DataFlavor[representationClass=").append(this.representationClass.getName()).append(",mimeType=").append(this.mimeType).append("humanPresentableName=").append(this.humanPresentableName).toString();
    }

    public static final DataFlavor getTextPlainUnicodeFlavor() {
        return plainTextFlavor;
    }

    public final Class getDefaultRepresentationClass() {
        return Class.forName("java.io.InputStream");
    }

    public final String getDefaultRepresentationClassAsString() {
        return this.getDefaultRepresentationClass().getName();
    }

    public static final DataFlavor selectBestTextFlavor(DataFlavor[] dataFlavorArray) {
        int n = 0;
        while (n < dataFlavorArray.length) {
            DataFlavor dataFlavor = dataFlavorArray[n];
            Class clazz = dataFlavor.representationClass;
            if (Class.forName("java.io.Reader").isAssignableFrom(clazz) || Class.forName("java.lang.String").isAssignableFrom(clazz)) {
                return dataFlavor;
            }
            if (Class.forName("java.io.InputStream").isAssignableFrom(clazz) && "text".equals(dataFlavor.getPrimaryType())) {
                String string = dataFlavorArray[n].getParameter("charset");
                if (string == null) {
                    string = "us-ascii";
                }
                InputStreamReader inputStreamReader = null;
                try {
                    inputStreamReader = new InputStreamReader(new ByteArrayInputStream(new byte[0]), string);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                if (inputStreamReader != null) {
                    return dataFlavor;
                }
            }
            ++n;
        }
        return null;
    }

    public Reader getReaderForText(Transferable transferable) throws UnsupportedFlavorException, IOException {
        if (!transferable.isDataFlavorSupported(this)) {
            throw new UnsupportedFlavorException(this);
        }
        if (Class.forName("java.io.Reader").isAssignableFrom(this.representationClass)) {
            return (Reader)transferable.getTransferData(this);
        }
        if (Class.forName("java.lang.String").isAssignableFrom(this.representationClass)) {
            return new StringReader((String)transferable.getTransferData(this));
        }
        if (Class.forName("java.io.InputStream").isAssignableFrom(this.representationClass) && "text".equals(this.getPrimaryType())) {
            InputStream inputStream = (InputStream)transferable.getTransferData(this);
            String string = this.getParameter("charset");
            if (string == null) {
                string = "us-ascii";
            }
            return new InputStreamReader(inputStream, string);
        }
        throw new UnsupportedFlavorException(this);
    }

    public boolean isRepresentationClassByteBuffer() {
        return Class.forName("java.nio.ByteBuffer").isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassCharBuffer() {
        return Class.forName("java.nio.CharBuffer").isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassReader() {
        return Class.forName("java.io.Reader").isAssignableFrom(this.representationClass);
    }
}

