/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GeneralPath
implements Shape,
Cloneable {
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;
    private static final int INIT_SIZE = 20;
    private int rule;
    private byte[] types;
    private float[] points;
    private int subpath;
    private int index;

    public GeneralPath() {
        this(1, 20);
    }

    public GeneralPath(int n) {
        this(n, 20);
    }

    public GeneralPath(int n, int n2) {
        this.Block$();
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException();
        }
        this.rule = n;
        if (n2 < 20) {
            n2 = 20;
        }
        this.types = new byte[n2 >> 1];
        this.points = new float[n2];
    }

    public GeneralPath(Shape shape) {
        this.Block$();
        this.types = new byte[10];
        this.points = new float[20];
        PathIterator pathIterator = shape.getPathIterator(null);
        this.setWindingRule(pathIterator.getWindingRule());
        this.append(pathIterator, false);
    }

    public void moveTo(float f, float f2) {
        this.subpath = this.index;
        this.ensureSize(this.index + 2);
        this.types[this.index >> 1] = 0;
        this.points[this.index++] = f;
        this.points[this.index++] = f2;
    }

    public void lineTo(float f, float f2) {
        this.ensureSize(this.index + 2);
        this.types[this.index >> 1] = 1;
        this.points[this.index++] = f;
        this.points[this.index++] = f2;
    }

    public void quadTo(float f, float f2, float f3, float f4) {
        this.ensureSize(this.index + 4);
        this.types[this.index >> 1] = 2;
        this.points[this.index++] = f;
        this.points[this.index++] = f2;
        this.points[this.index++] = f3;
        this.points[this.index++] = f4;
    }

    public void curveTo(float f, float f2, float f3, float f4, float f5, float f6) {
        this.ensureSize(this.index + 6);
        this.types[this.index >> 1] = 2;
        this.points[this.index++] = f;
        this.points[this.index++] = f2;
        this.points[this.index++] = f3;
        this.points[this.index++] = f4;
        this.points[this.index++] = f5;
        this.points[this.index++] = f6;
    }

    public void closePath() {
        this.ensureSize(this.index + 2);
        this.types[this.index >> 1] = 4;
        this.points[this.index++] = this.points[this.subpath];
        this.points[this.index++] = this.points[this.subpath + 1];
    }

    public void append(Shape shape, boolean bl) {
        this.append(shape.getPathIterator(null), bl);
    }

    public void append(PathIterator pathIterator, boolean bl) {
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    if (!bl) {
                        this.moveTo(fArray[0], fArray[1]);
                        break;
                    }
                    if (this.subpath >= 0 && fArray[0] == this.points[this.subpath] && fArray[1] == this.points[this.subpath + 1]) break;
                }
                case 1: {
                    this.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    this.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    this.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                default: {
                    this.closePath();
                }
            }
            bl = false;
        }
    }

    public int getWindingRule() {
        return this.rule;
    }

    public void setWindingRule(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException();
        }
        this.rule = n;
    }

    public Point2D getCurrentPoint() {
        if (this.subpath < 0) {
            return null;
        }
        return new Point2D.Float(this.points[this.subpath], this.points[this.subpath + 1]);
    }

    public void reset() {
        this.subpath = -1;
        this.index = 0;
    }

    public void transform(AffineTransform affineTransform) {
        affineTransform.transform(this.points, 0, this.points, 0, this.index >> 1);
    }

    public Shape createTransformedShape(AffineTransform affineTransform) {
        GeneralPath generalPath = new GeneralPath(this);
        generalPath.transform(affineTransform);
        return generalPath;
    }

    @Override
    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        throw new Error("not implemented");
    }

    @Override
    public boolean contains(double d, double d2) {
        throw new Error("not implemented");
    }

    @Override
    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    @Override
    public boolean contains(double d, double d2, double d3, double d4) {
        throw new Error("not implemented");
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public boolean intersects(double d, double d2, double d3, double d4) {
        throw new Error("not implemented");
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new 1(this, affineTransform);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return new FlatteningPathIterator(this.getPathIterator(affineTransform), d);
    }

    public Object clone() {
        return new GeneralPath(this);
    }

    private void ensureSize(int n) {
        if (this.subpath < 0) {
            throw new IllegalPathStateException("need initial moveto");
        }
        if (n <= this.points.length) {
            return;
        }
        byte[] byArray = new byte[this.points.length];
        System.arraycopy(this.types, 0, byArray, 0, this.index >> 1);
        this.types = byArray;
        float[] fArray = new float[this.points.length << 1];
        System.arraycopy(this.points, 0, fArray, 0, this.index);
        this.points = fArray;
    }

    private /* synthetic */ void Block$() {
        this.subpath = -1;
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class 1
    implements PathIterator {
        int current;
        private final /* synthetic */ GeneralPath this$0;
        private final /* synthetic */ AffineTransform var$at;

        @Override
        public int getWindingRule() {
            return this.this$0.rule;
        }

        @Override
        public boolean isDone() {
            return this.current >= this.this$0.index;
        }

        @Override
        public void next() {
            ++this.current;
        }

        @Override
        public int currentSegment(float[] fArray) {
            if (this.current >= this.this$0.index) {
                return 4;
            }
            byte by = this.this$0.types[this.current >> 1];
            int n = 0;
            if (by == 3) {
                fArray[n++] = this.this$0.points[this.current++];
                fArray[n++] = this.this$0.points[this.current++];
            }
            if (by == 2) {
                fArray[n++] = this.this$0.points[this.current++];
                fArray[n++] = this.this$0.points[this.current++];
            }
            if (by < 2) {
                fArray[n++] = this.this$0.points[this.current++];
                fArray[n++] = this.this$0.points[this.current++];
                if (this.var$at != null) {
                    this.var$at.transform(fArray, 0, fArray, 0, (int)(by == 0 ? (byte)1 : by));
                }
            }
            return by;
        }

        @Override
        public int currentSegment(double[] dArray) {
            if (this.current >= this.this$0.index) {
                return 4;
            }
            byte by = this.this$0.types[this.current >> 1];
            int n = 0;
            if (by == 3) {
                dArray[n++] = this.this$0.points[this.current++];
                dArray[n++] = this.this$0.points[this.current++];
            }
            if (by == 2) {
                dArray[n++] = this.this$0.points[this.current++];
                dArray[n++] = this.this$0.points[this.current++];
            }
            if (by < 2) {
                dArray[n++] = this.this$0.points[this.current++];
                dArray[n++] = this.this$0.points[this.current++];
                if (this.var$at != null) {
                    this.var$at.transform(dArray, 0, dArray, 0, (int)(by == 0 ? (byte)1 : by));
                }
            }
            return by;
        }

        public 1() {
            this.this$0 = var1_1;
            this.var$at = var2_2;
            this.Block$();
        }

        private /* synthetic */ void Block$() {
            this.current = 0;
        }
    }
}

