/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RectangularShape
implements Shape,
Cloneable {
    protected RectangularShape() {
    }

    public abstract double getX();

    public abstract double getY();

    public abstract double getWidth();

    public abstract double getHeight();

    public double getMinX() {
        return this.getX();
    }

    public double getMinY() {
        return this.getY();
    }

    public double getMaxX() {
        return this.getX() + this.getWidth();
    }

    public double getMaxY() {
        return this.getY() + this.getHeight();
    }

    public double getCenterX() {
        return this.getX() + this.getWidth() / 2.0;
    }

    public double getCenterY() {
        return this.getY() + this.getHeight() / 2.0;
    }

    public Rectangle2D getFrame() {
        return new Rectangle2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public abstract boolean isEmpty();

    public abstract void setFrame(double var1, double var3, double var5, double var7);

    public void setFrame(Point2D point2D, Dimension2D dimension2D) {
        this.setFrame(point2D.getX(), point2D.getY(), dimension2D.getWidth(), dimension2D.getHeight());
    }

    public void setFrame(Rectangle2D rectangle2D) {
        this.setFrame(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public void setFrameFromDiagonal(double d, double d2, double d3, double d4) {
        double d5;
        if (d > d3) {
            d5 = d3;
            d3 = d;
            d = d5;
        }
        if (d2 > d4) {
            d5 = d4;
            d4 = d2;
            d2 = d5;
        }
        this.setFrame(d, d2, d3 - d, d4 - d2);
    }

    public void setFrameFromDiagonal(Point2D point2D, Point2D point2D2) {
        this.setFrameFromDiagonal(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
    }

    public void setFrameFromCenter(double d, double d2, double d3, double d4) {
        double d5 = Math.abs(d3 - d);
        double d6 = Math.abs(d4 - d2);
        this.setFrame(d - d5, d2 - d6, d5 + d5, d6 + d6);
    }

    public void setFrameFromCenter(Point2D point2D, Point2D point2D2) {
        this.setFrameFromCenter(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
    }

    @Override
    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public Rectangle getBounds() {
        if (this.isEmpty()) {
            return new Rectangle();
        }
        double d = this.getX();
        double d2 = this.getY();
        double d3 = Math.ceil(d + this.getWidth());
        double d4 = Math.ceil(d2 + this.getHeight());
        d = Math.floor(d);
        d2 = Math.floor(d2);
        return new Rectangle((int)d, (int)d2, (int)(d3 - d), (int)(d4 - d2));
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return new FlatteningPathIterator(this.getPathIterator(affineTransform), d);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw (Error)new InternalError().initCause(cloneNotSupportedException);
        }
    }
}

