/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.Buffers;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentColorModel
extends ColorModel {
    private static int sum(int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            n += nArray[n2];
            ++n2;
        }
        return n;
    }

    public ComponentColorModel(ColorSpace colorSpace, int[] nArray, boolean bl, boolean bl2, int n, int n2) {
        super(ComponentColorModel.sum(nArray), nArray, colorSpace, bl, bl2, n, n2);
    }

    @Override
    public int getRed(int n) {
        if (this.getNumComponents() > 1) {
            throw new IllegalArgumentException();
        }
        return (int)this.getRGBFloat(n)[0];
    }

    @Override
    public int getGreen(int n) {
        if (this.getNumComponents() > 1) {
            throw new IllegalArgumentException();
        }
        return (int)this.getRGBFloat(n)[0];
    }

    @Override
    public int getBlue(int n) {
        if (this.getNumComponents() > 1) {
            throw new IllegalArgumentException();
        }
        return (int)this.getRGBFloat(n)[0];
    }

    @Override
    public int getAlpha(int n) {
        if (this.getNumComponents() > 1) {
            throw new IllegalArgumentException();
        }
        int n2 = 8 - this.getComponentSize(this.getNumColorComponents());
        if (n2 >= 0) {
            return n << n2;
        }
        return n >> -n2;
    }

    @Override
    public int getRGB(int n) {
        float[] fArray = this.getRGBFloat(n);
        int n2 = this.getRGB(fArray);
        if (this.hasAlpha()) {
            n2 |= this.getAlpha(n) << 24;
        }
        return n2;
    }

    private float[] getRGBFloat(int n) {
        float[] fArray = new float[]{n};
        return this.cspace.toRGB(fArray);
    }

    private float[] getRGBFloat(Object object) {
        DataBuffer dataBuffer = Buffers.createBufferFromData(this.transferType, object, this.getNumComponents());
        int n = this.getNumColorComponents();
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            float f = (1 << this.getComponentSize(n2)) - 1;
            fArray[n2] = dataBuffer.getElemFloat(n2) / f;
            ++n2;
        }
        float[] fArray2 = this.cspace.toRGB(fArray);
        return fArray2;
    }

    @Override
    public int getRed(Object object) {
        return (int)this.getRGBFloat(object)[0] * 255;
    }

    @Override
    public int getGreen(Object object) {
        return (int)this.getRGBFloat(object)[1] * 255;
    }

    @Override
    public int getBlue(Object object) {
        return (int)this.getRGBFloat(object)[2] * 255;
    }

    @Override
    public int getAlpha(Object object) {
        DataBuffer dataBuffer = Buffers.createBufferFromData(this.transferType, object, this.getNumComponents());
        int n = 8 - this.getComponentSize(this.getNumColorComponents());
        int n2 = dataBuffer.getElem(this.getNumColorComponents());
        if (n >= 0) {
            return n2 << n;
        }
        return n2 >> -n;
    }

    private int getRGB(float[] fArray) {
        int n = (int)(fArray[0] * 255.0f) << 16 | (int)(fArray[1] * 255.0f) << 8 | (int)(fArray[2] * 255.0f) << 0;
        return n;
    }

    @Override
    public int getRGB(Object object) {
        float[] fArray = this.getRGBFloat(object);
        int n = this.getRGB(fArray);
        if (this.hasAlpha()) {
            n |= this.getAlpha(object) << 24;
        }
        return n;
    }

    @Override
    public Object getDataElements(int n, Object object) {
        float[] fArray = new float[]{(float)(n >> 16 & 0xFF) / 255.0f, (float)(n >> 8 & 0xFF) / 255.0f, (float)(n >> 0 & 0xFF) / 255.0f};
        float[] fArray2 = this.cspace.fromRGB(fArray);
        DataBuffer dataBuffer = Buffers.createBuffer(this.transferType, object, this.getNumComponents());
        int n2 = this.getNumColorComponents();
        if (this.hasAlpha()) {
            float f = (float)(n >> 24 & 0xFF) / 255.0f;
            if (this.isAlphaPremultiplied()) {
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = n3++;
                    fArray2[n4] = fArray2[n4] * f;
                }
            }
            dataBuffer.setElemFloat(n2, f *= (float)(1 << this.bits[n2] - 1));
        }
        int n5 = 0;
        while (n5 < n2) {
            float f = fArray2[n5] * (float)(1 << this.bits[n5] - 1);
            dataBuffer.setElemFloat(n5, f);
            ++n5;
        }
        return Buffers.getData(dataBuffer);
    }

    @Override
    public int[] getComponents(int n, int[] nArray, int n2) {
        if (this.getNumComponents() > 1) {
            throw new IllegalArgumentException();
        }
        if (nArray == null) {
            nArray = new int[this.getNumComponents() + n2];
        }
        nArray[n2] = n;
        return nArray;
    }

    @Override
    public int[] getComponents(Object object, int[] nArray, int n) {
        DataBuffer dataBuffer = Buffers.createBuffer(this.transferType, object, this.getNumComponents());
        int n2 = this.getNumComponents();
        if (nArray == null) {
            nArray = new int[n2 + n];
        }
        int n3 = 0;
        while (n3 < n2) {
            nArray[n++] = dataBuffer.getElem(n3);
            ++n3;
        }
        return nArray;
    }

    @Override
    public int getDataElement(int[] nArray, int n) {
        if (this.getNumComponents() > 1) {
            throw new IllegalArgumentException();
        }
        return nArray[n];
    }

    @Override
    public Object getDataElements(int[] nArray, int n, Object object) {
        DataBuffer dataBuffer = Buffers.createBuffer(this.transferType, object, this.getNumComponents());
        int n2 = this.getNumComponents();
        int n3 = 0;
        while (n3 < n2) {
            dataBuffer.setElem(n3, nArray[n++]);
            ++n3;
        }
        return Buffers.getData(dataBuffer);
    }

    @Override
    public ColorModel coerceData(WritableRaster writableRaster, boolean bl) {
        if (this.isAlphaPremultiplied == bl) {
            return this;
        }
        super.coerceData(writableRaster, bl);
        return new ComponentColorModel(this.cspace, this.bits, this.hasAlpha(), bl, this.transparency, this.transferType);
    }

    @Override
    public boolean isCompatibleRaster(Raster raster) {
        return super.isCompatibleRaster(raster);
    }

    @Override
    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        SampleModel sampleModel = this.createCompatibleSampleModel(n, n2);
        Point point = new Point(0, 0);
        return Raster.createWritableRaster(sampleModel, point);
    }

    @Override
    public SampleModel createCompatibleSampleModel(int n, int n2) {
        int n3 = this.getNumComponents();
        int[] nArray = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            nArray[n4] = n4;
            ++n4;
        }
        return new ComponentSampleModel(this.transferType, n, n2, n3, n3 * n, nArray);
    }

    @Override
    public boolean isCompatibleSampleModel(SampleModel sampleModel) {
        return sampleModel instanceof ComponentSampleModel && super.isCompatibleSampleModel(sampleModel);
    }

    @Override
    public WritableRaster getAlphaRaster(WritableRaster writableRaster) {
        if (!this.hasAlpha()) {
            return null;
        }
        SampleModel sampleModel = writableRaster.getSampleModel();
        int[] nArray = new int[]{sampleModel.getNumBands() - 1};
        SampleModel sampleModel2 = sampleModel.createSubsetSampleModel(nArray);
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        Point point = new Point(0, 0);
        return Raster.createWritableRaster(sampleModel2, dataBuffer, point);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ComponentColorModel)) {
            return false;
        }
        return super.equals(object);
    }
}

