/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.BitMaskExtent;
import gnu.java.awt.Buffers;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.SampleModel;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SinglePixelPackedSampleModel
extends SampleModel {
    private int scanlineStride;
    private int[] bitMasks;
    private int[] bitOffsets;
    private int[] sampleSize;

    public SinglePixelPackedSampleModel(int n, int n2, int n3, int[] nArray) {
        this(n, n2, n3, n2, nArray);
    }

    public SinglePixelPackedSampleModel(int n, int n2, int n3, int n4, int[] nArray) {
        super(n, n2, n3, nArray.length);
        this.scanlineStride = n4;
        this.bitMasks = nArray;
        this.bitOffsets = new int[this.numBands];
        this.sampleSize = new int[this.numBands];
        BitMaskExtent bitMaskExtent = new BitMaskExtent();
        int n5 = 0;
        while (n5 < this.numBands) {
            bitMaskExtent.setMask(nArray[n5]);
            this.sampleSize[n5] = bitMaskExtent.bitWidth;
            this.bitOffsets[n5] = bitMaskExtent.leastSignificantBit;
            ++n5;
        }
    }

    @Override
    public int getNumDataElements() {
        return 1;
    }

    @Override
    public SampleModel createCompatibleSampleModel(int n, int n2) {
        return new SinglePixelPackedSampleModel(this.dataType, n, n2, this.bitMasks);
    }

    @Override
    public DataBuffer createDataBuffer() {
        int n = this.scanlineStride * this.height;
        return Buffers.createBuffer(this.getDataType(), n);
    }

    @Override
    public int[] getSampleSize() {
        return this.sampleSize;
    }

    @Override
    public int getSampleSize(int n) {
        return this.sampleSize[n];
    }

    public int getOffset(int n, int n2) {
        return this.scanlineStride * n2 + n;
    }

    public int[] getBitOffsets() {
        return this.bitOffsets;
    }

    public int[] getBitMasks() {
        return this.bitMasks;
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    @Override
    public SampleModel createSubsetSampleModel(int[] nArray) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray2[n2] = this.bitMasks[nArray[n2]];
            ++n2;
        }
        return new SinglePixelPackedSampleModel(this.dataType, this.width, this.height, this.scanlineStride, nArray2);
    }

    @Override
    public Object getDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        int n3 = this.scanlineStride * n2 + n + dataBuffer.getOffset();
        return Buffers.getData(dataBuffer, n3, object, 0, 1);
    }

    @Override
    public int[] getPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        int n3 = this.scanlineStride * n2 + n;
        if (nArray == null) {
            nArray = new int[this.numBands];
        }
        int n4 = dataBuffer.getElem(n3);
        int n5 = 0;
        while (n5 < this.numBands) {
            nArray[n5] = (n4 & this.bitMasks[n5]) >>> this.bitOffsets[n5];
            ++n5;
        }
        return nArray;
    }

    @Override
    public int[] getPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        int n5 = this.scanlineStride * n2 + n;
        if (nArray == null) {
            nArray = new int[this.numBands * n3 * n4];
        }
        int n6 = 0;
        n2 = 0;
        while (n2 < n4) {
            int n7 = n5;
            n = 0;
            while (n < n3) {
                int n8 = dataBuffer.getElem(n7++);
                int n9 = 0;
                while (n9 < this.numBands) {
                    nArray[n6++] = (n8 & this.bitMasks[n9]) >>> this.bitOffsets[n9];
                    ++n9;
                }
                ++n;
            }
            n5 += this.scanlineStride;
            ++n2;
        }
        return nArray;
    }

    @Override
    public int getSample(int n, int n2, int n3, DataBuffer dataBuffer) {
        int n4 = this.scanlineStride * n2 + n;
        int n5 = dataBuffer.getElem(n4);
        return (n5 & this.bitMasks[n3]) >>> this.bitOffsets[n3];
    }

    @Override
    public void setDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        int n3 = this.scanlineStride * n2 + n + dataBuffer.getOffset();
        int n4 = this.getTransferType();
        if (this.getTransferType() != dataBuffer.getDataType()) {
            throw new IllegalArgumentException(new StringBuffer().append("transfer type (").append(this.getTransferType()).append("), ").append("does not match data ").append("buffer type (").append(dataBuffer.getDataType()).append(").").toString());
        }
        try {
            switch (n4) {
                case 0: {
                    DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
                    byte[] byArray = (byte[])object;
                    dataBufferByte.getData()[n3] = byArray[0];
                    return;
                }
                case 1: {
                    DataBufferUShort dataBufferUShort = (DataBufferUShort)dataBuffer;
                    short[] sArray = (short[])object;
                    dataBufferUShort.getData()[n3] = sArray[0];
                    return;
                }
                case 3: {
                    DataBufferInt dataBufferInt = (DataBufferInt)dataBuffer;
                    int[] nArray = (int[])object;
                    dataBufferInt.getData()[n3] = nArray[0];
                    return;
                }
            }
            throw new InternalError();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            String string = new StringBuffer().append("While writing data elements, x=").append(n).append(", y=").append(n2).append(", width=").append(this.width).append(", height=").append(this.height).append(", scanlineStride=").append(this.scanlineStride).append(", offset=").append(n3).append(", data.getSize()=").append(dataBuffer.getSize()).append(", data.getOffset()=").append(dataBuffer.getOffset()).append(": ").append(arrayIndexOutOfBoundsException).toString();
            throw new ArrayIndexOutOfBoundsException(string);
        }
    }

    @Override
    public void setPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        int n3 = this.scanlineStride * n2 + n;
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.numBands) {
            n4 |= nArray[n5] << this.bitOffsets[n5] & this.bitMasks[n5];
            ++n5;
        }
        dataBuffer.setElem(n3, n4);
    }

    @Override
    public void setSample(int n, int n2, int n3, int n4, DataBuffer dataBuffer) {
        int n5 = this.scanlineStride * n2 + n;
        int n6 = dataBuffer.getElem(n5);
        int n7 = this.bitMasks[n3];
        n6 &= ~n7;
        dataBuffer.setElem(n5, n6 |= n4 << this.bitOffsets[n3] & n7);
    }
}

