/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyDescriptor
extends FeatureDescriptor {
    private Class rettype;
    private Method getter;
    private Method setter;
    private boolean bound;
    private boolean constrained;
    private Class editor;

    public PropertyDescriptor(String string, Class clazz) throws IntrospectionException {
        super(string);
        String string2 = FeatureDescriptor.capitalize(string);
        String string3 = new StringBuffer().append("set").append(string2).toString();
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            Method method = methodArray[n];
            if (string3.equals(method.getName()) && method.getParameterTypes().length == 1) {
                this.checkSetter(method);
                this.setter = method;
                this.rettype = this.setter.getParameterTypes()[0];
                break;
            }
            ++n;
        }
        if (this.setter == null) {
            throw new IntrospectionException(new StringBuffer().append("Class ").append(clazz.getName()).append(" does not have a setter method ").append(string3).toString());
        }
        if (this.rettype == Boolean.TYPE) {
            string3 = new StringBuffer().append("is").append(string2).toString();
            try {
                this.getter = clazz.getMethod(string3, null);
                this.checkGetter(this.getter);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (this.getter == null) {
            string3 = new StringBuffer().append("get").append(string2).toString();
            try {
                this.getter = clazz.getMethod(string3, null);
                this.checkGetter(this.getter);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IntrospectionException(noSuchMethodException.getMessage());
            }
        }
        this.checkGetterAndSetterMatch();
    }

    public PropertyDescriptor(String string, Class clazz, String string2, String string3) throws IntrospectionException {
        super(string);
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            Method method = methodArray[n];
            if (string2 != null && this.getter == null && string2.equals(method.getName()) && method.getParameterTypes().length == 0) {
                this.checkGetter(method);
                this.getter = method;
                this.rettype = this.getter.getReturnType();
            } else if (string3 != null && this.setter == null && string3.equals(method.getName()) && method.getParameterTypes().length == 1) {
                this.checkSetter(method);
                this.setter = method;
                this.rettype = this.setter.getReturnType();
            }
            ++n;
        }
        this.checkGetterAndSetterMatch();
    }

    public PropertyDescriptor(String string, Method method, Method method2) throws IntrospectionException {
        super(string);
        this.getter = method;
        this.setter = method2;
        if (method != null) {
            this.rettype = method.getReturnType();
        } else if (method2 != null) {
            this.rettype = method2.getParameterTypes()[0];
        }
        this.checkGetterAndSetterMatch();
    }

    private void checkGetterAndSetterMatch() throws IntrospectionException {
        if (this.getter != null && this.getter.getReturnType() != this.rettype || this.setter != null && this.setter.getParameterTypes()[0] != this.rettype) {
            throw new IntrospectionException(new StringBuffer().append("Getter method ").append(this.getter).append(" and setter method ").append(this.setter).append(" don't match.").toString());
        }
    }

    private void checkSetter(Method method) throws IntrospectionException {
        if (method.getParameterTypes().length != 1) {
            throw new IntrospectionException(new StringBuffer().append("Setter method ").append(method).append(" must accept only one pararmeter.").toString());
        }
        if (method.getReturnType() != Void.TYPE) {
            throw new IntrospectionException(new StringBuffer().append("Setter method ").append(method).append(" must return void.").toString());
        }
    }

    private void checkGetter(Method method) throws IntrospectionException {
        if (method.getParameterTypes().length != 0) {
            throw new IntrospectionException(new StringBuffer().append("Getter method ").append(method).append(" must not accept any pararmeters.").toString());
        }
        if (method.getReturnType() == Void.TYPE) {
            throw new IntrospectionException(new StringBuffer().append("Getter method ").append(method).append(" must not return void.").toString());
        }
    }

    public Class getPropertyEditorClass() {
        return this.editor;
    }

    public Class getPropertyType() {
        return this.rettype;
    }

    public Method getReadMethod() {
        return this.getter;
    }

    public Method getWriteMethod() {
        return this.setter;
    }

    public boolean isBound() {
        return this.bound;
    }

    public boolean isConstrained() {
        return this.constrained;
    }

    public void setBound(boolean bl) {
        this.bound = bl;
    }

    public void setConstrained(boolean bl) {
        this.constrained = bl;
    }

    public void setPropertyEditorClass(Class clazz) {
        this.editor = clazz;
    }
}

