/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedInputStream
extends FilterInputStream {
    protected byte[] buf;
    protected int count;
    protected int pos;
    protected int markpos;
    protected int marklimit;
    private final byte[] single;
    private static final int DEFAULTBUFFER = 2048;

    public BufferedInputStream(InputStream inputStream) {
        this(inputStream, 2048);
    }

    public BufferedInputStream(InputStream inputStream, int n) {
        super(inputStream);
        this.Block$();
        if (n <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[n];
        this.marklimit = n;
        this.markpos = -1;
    }

    @Override
    public synchronized int available() throws IOException {
        this.checkIfStillOpen();
        return this.count - this.pos + this.in.available();
    }

    private void checkIfStillOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("stream closed");
        }
    }

    @Override
    public synchronized void mark(int n) {
        if (n > this.buf.length - this.pos) {
            byte[] byArray = n <= this.buf.length ? this.buf : new byte[n];
            System.arraycopy(this.buf, this.pos, byArray, 0, this.count - this.pos);
            this.buf = byArray;
            this.count -= this.pos;
            this.markpos = 0;
            this.pos = 0;
        } else {
            this.markpos = this.pos;
        }
        this.marklimit = n;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this._read(this.single, 0, 1) == -1) {
            return -1;
        }
        return this.single[0] & 0xFF;
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        return this._read(byArray, n, n2);
    }

    private int _read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        this.checkIfStillOpen();
        if (n2 == 1 && this.pos < this.count) {
            byArray[n] = this.buf[this.pos++];
            return 1;
        }
        int n4 = 0;
        do {
            if (this.pos == this.buf.length) {
                this.count = 0;
                this.pos = 0;
                this.markpos = -1;
            }
            if (this.pos == this.count) {
                if (n2 >= this.buf.length) {
                    n3 = super.read(byArray, n, n2);
                    if (n3 == -1) {
                        if (n4 > 0) {
                            return n4;
                        }
                        return -1;
                    }
                    return n4 + n3;
                }
                if (!this.fillBuffer()) {
                    if (n4 > 0) {
                        return n4;
                    }
                    return -1;
                }
            }
            n3 = Math.min(this.count - this.pos, n2);
            System.arraycopy(this.buf, this.pos, byArray, n, n3);
            n4 += n3;
            this.pos += n3;
            n += n3;
        } while ((n2 -= n3) > 0 && this.available() > 0);
        return n4;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.checkIfStillOpen();
        if (this.markpos == -1) {
            throw new IOException(new StringBuffer().append("Attempt to reset when no mark is valid (marklimit=").append(this.marklimit).append(")").toString());
        }
        this.pos = this.markpos;
    }

    @Override
    public synchronized long skip(long l) throws IOException {
        this.checkIfStillOpen();
        if (l <= 0L) {
            return 0L;
        }
        if (this.pos < this.count) {
            if ((long)(this.count - this.pos) > l) {
                this.pos += (int)l;
            } else {
                l = this.count - this.pos;
                this.pos = this.count;
            }
            return l;
        }
        if (this.pos == this.buf.length) {
            this.count = 0;
            this.pos = 0;
            this.markpos = -1;
            return super.skip(l);
        }
        if (this.fillBuffer()) {
            return this.skip(l);
        }
        return 0L;
    }

    private boolean fillBuffer() throws IOException {
        int n = super.read(this.buf, this.pos, this.buf.length - this.pos);
        if (n <= 0) {
            return false;
        }
        this.count += n;
        return true;
    }

    private /* synthetic */ void Block$() {
        this.single = new byte[1];
    }
}

