/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedOutputStream
extends FilterOutputStream {
    private static final int DEFAULTBUFFER = 2048;
    protected byte[] buf;
    protected int count;

    public BufferedOutputStream(OutputStream outputStream) {
        this(outputStream, 2048);
    }

    public BufferedOutputStream(OutputStream outputStream, int n) {
        super(outputStream);
        if (n <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[n];
        this.count = 0;
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.count > 0) {
            try {
                this.out.write(this.buf, 0, this.count);
                this.count = 0;
            }
            catch (InterruptedIOException interruptedIOException) {
                this.count -= interruptedIOException.bytesTransferred;
                throw interruptedIOException;
            }
        }
        this.out.flush();
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.count + n2 <= this.buf.length) {
            System.arraycopy(byArray, n, this.buf, this.count, n2);
            this.count += n2;
            return;
        }
        if (this.count > 0) {
            try {
                this.out.write(this.buf, 0, this.count);
                this.count = 0;
            }
            catch (InterruptedIOException interruptedIOException) {
                this.count -= interruptedIOException.bytesTransferred;
                throw interruptedIOException;
            }
        }
        this.out.write(byArray, n, n2);
    }

    @Override
    public synchronized void write(int n) throws IOException {
        if (this.count == this.buf.length) {
            try {
                this.out.write(this.buf, 0, this.buf.length);
                this.count = 0;
            }
            catch (InterruptedIOException interruptedIOException) {
                this.count -= interruptedIOException.bytesTransferred;
                throw interruptedIOException;
            }
        }
        this.buf[this.count++] = (byte)n;
    }
}

