/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteArrayOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;

    public ByteArrayOutputStream() {
        this(32);
    }

    public ByteArrayOutputStream(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(new StringBuffer().append("Negative initial size: ").append(n).toString());
        }
        this.buf = new byte[n];
        this.count = 0;
    }

    private void ensureCapacity(int n) {
        if (n > this.buf.length) {
            byte[] byArray = this.buf;
            this.buf = new byte[n + 32];
            System.arraycopy(byArray, 0, this.buf, 0, byArray.length);
        }
    }

    public synchronized void reset() {
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public synchronized byte[] toByteArray() {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        return byArray;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public String toString(String string) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, string);
    }

    public String toString(int n) {
        return new String(this.buf, n, 0, this.count);
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.count + n2);
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count += n2;
    }

    @Override
    public synchronized void write(int n) {
        this.ensureCapacity(this.count + 1);
        this.buf[this.count++] = (byte)n;
    }

    public synchronized void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.count);
    }
}

