/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import kaffe.util.UTF8;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataInputStream
extends FilterInputStream
implements DataInput {
    public DataInputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public final int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        return super.read(byArray, n, n2);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this.readUnsignedByte() != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        int n = this.read();
        if (n == -1) {
            throw new EOFException();
        }
        return (byte)n;
    }

    @Override
    public final char readChar() throws IOException {
        int n = this.readUnsignedByte() << 8;
        return (char)(n |= this.readUnsignedByte());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.read(byArray, n + n3, n2 - n3);
            if (n4 == -1) {
                throw new EOFException();
            }
            n3 += n4;
        }
    }

    @Override
    public final int readInt() throws IOException {
        int n = this.readUnsignedByte() << 24;
        n |= this.readUnsignedByte() << 16;
        n |= this.readUnsignedByte() << 8;
        return n |= this.readUnsignedByte();
    }

    @Override
    public final String readLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        try {
            char c;
            while ((c = (char)this.readUnsignedByte()) != '\n') {
                if (c == '\r') {
                    int n;
                    if (this.available() > 0 && (n = this.read()) != -1 && n != 10) {
                        this.buffer = n;
                    }
                    break;
                }
                stringBuffer.append(c);
            }
        }
        catch (EOFException eOFException) {
            bl = true;
        }
        if (bl && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    @Override
    public final long readLong() throws IOException {
        return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public final short readShort() throws IOException {
        int n = this.readUnsignedByte() << 8;
        return (short)(n |= this.readUnsignedByte());
    }

    @Override
    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public static final String readUTF(DataInput dataInput) throws IOException {
        return UTF8.decode(dataInput, dataInput.readUnsignedShort());
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        int n2 = n;
        while (n2 > 0) {
            n2 -= (int)this.in.skip(n2);
        }
        return n;
    }
}

