/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.OutputStream;
import kaffe.util.IdentityHashtable;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectOutputStream
extends OutputStream
implements ObjectOutput,
ObjectStreamConstants {
    private static final boolean DOTRACE = false;
    private final Output out;
    private boolean enableReplace;
    private int nextKey;
    private final IdentityHashtable objectReferences;
    private Object currentObject;
    private ObjectStreamClass currentStreamClass;

    public ObjectOutputStream(OutputStream outputStream) throws IOException {
        this.Block$();
        this.out = new Output(outputStream);
        this.writeStreamHeader();
        this.out.enableBuffering(true);
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
    }

    @Override
    public void writeBoolean(boolean bl) throws IOException {
        this.out.writeBoolean(bl);
    }

    @Override
    public void writeByte(int n) throws IOException {
        this.out.writeByte(n);
    }

    @Override
    public void writeBytes(String string) throws IOException {
        this.out.writeBytes(string);
    }

    @Override
    public void writeChar(int n) throws IOException {
        this.out.writeChar(n);
    }

    @Override
    public void writeChars(String string) throws IOException {
        this.out.writeChars(string);
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.out.writeDouble(d);
    }

    @Override
    public void writeFloat(float f) throws IOException {
        this.out.writeFloat(f);
    }

    @Override
    public void writeInt(int n) throws IOException {
        this.out.writeInt(n);
    }

    @Override
    public void writeLong(long l) throws IOException {
        this.out.writeLong(l);
    }

    @Override
    public void writeShort(int n) throws IOException {
        this.out.writeShort(n);
    }

    @Override
    public void writeUTF(String string) throws IOException {
        this.out.writeUTF(string);
    }

    @Override
    public void write(int n) throws IOException {
        this.out.write(n);
    }

    public void reset() throws IOException {
        this.flush();
        this.resetObjectReferences();
        this.writeByte(121);
    }

    protected void drain() throws IOException {
        this.flush();
    }

    protected void annotateClass(Class clazz) throws IOException {
    }

    void annotateClassInternal(Class clazz) throws IOException {
        this.annotateClass(clazz);
    }

    protected boolean enableReplaceObject(boolean bl) throws SecurityException {
        boolean bl2 = this.enableReplace;
        this.enableReplace = bl;
        return bl2;
    }

    protected Object replaceObject(Object object) throws IOException {
        return object;
    }

    @Override
    public final void writeObject(Object object) throws IOException {
        Class clazz;
        ObjectStreamClass objectStreamClass;
        if (this.enableReplace) {
            object = this.replaceObject(object);
        }
        boolean bl = this.out.enableBuffering(false);
        if (object == null) {
            this.writeByte(112);
            this.out.enableBuffering(bl);
            return;
        }
        if (object instanceof Class) {
            object = ObjectStreamClass.lookup((Class)object);
        }
        if ((objectStreamClass = ObjectStreamClass.lookup(clazz = object.getClass())) == null) {
            throw new NotSerializableException();
        }
        Integer n = (Integer)this.objectReferences.get(object);
        if (n != null) {
            this.writeByte(113);
            this.writeInt(n);
        } else if (clazz.isArray()) {
            this.writeByte(117);
            this.writeObject(clazz);
            objectStreamClass.putArray(object, this);
        } else if (object instanceof String) {
            this.writeByte(116);
            this.writeUTF((String)object);
            this.makeObjectReference(object);
        } else if (object instanceof ObjectStreamClass) {
            while (object != null) {
                this.writeByte(114);
                objectStreamClass.putClass(object, this);
                object = ObjectStreamClass.lookup(((ObjectStreamClass)object).forClass().getSuperclass());
            }
            this.writeObject(null);
        } else {
            this.writeByte(115);
            this.writeObject(clazz);
            objectStreamClass.putObject(object, this);
        }
        this.out.enableBuffering(bl);
    }

    public void defaultWriteObject() throws IOException {
        if (this.currentObject == null || this.currentStreamClass == null) {
            throw new NotActiveException();
        }
        boolean bl = this.out.enableBuffering(false);
        this.currentStreamClass.defaultWriteObject(this.currentObject, this);
        this.out.enableBuffering(bl);
    }

    public PutField putFields() throws IOException {
        if (this.currentObject == null || this.currentStreamClass == null) {
            throw new NotActiveException();
        }
        return this.currentStreamClass.putFields();
    }

    public void writeFields() throws IOException {
        if (this.currentObject == null || this.currentStreamClass == null) {
            throw new NotActiveException();
        }
        boolean bl = this.out.enableBuffering(false);
        this.currentStreamClass.writeFields(this.currentObject, this);
        this.out.enableBuffering(bl);
    }

    protected void writeStreamHeader() throws IOException {
        this.writeShort(-21267);
        this.writeShort(5);
        this.out.flush();
    }

    boolean enableBuffering(boolean bl) throws IOException {
        return this.out.enableBuffering(bl);
    }

    void makeObjectReference(Object object) {
        this.objectReferences.put(object, new Integer(this.nextKey));
        ++this.nextKey;
    }

    private void resetObjectReferences() {
        this.objectReferences.clear();
    }

    private /* synthetic */ void Block$() {
        this.nextKey = 0x7E0000;
        this.objectReferences = new IdentityHashtable();
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class PutField {
        public abstract void put(String var1, boolean var2);

        public abstract void put(String var1, byte var2);

        public abstract void put(String var1, char var2);

        public abstract void put(String var1, short var2);

        public abstract void put(String var1, int var2);

        public abstract void put(String var1, long var2);

        public abstract void put(String var1, float var2);

        public abstract void put(String var1, double var2);

        public abstract void put(String var1, Object var2);

        public abstract void write(ObjectOutput var1) throws IOException;
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Output
    extends DataOutputStream {
        private final ByteArrayOutputStream buffer;
        private boolean buffering;

        Output(OutputStream outputStream) {
            super(outputStream);
            this.Block$();
            this.buffering = false;
        }

        boolean enableBuffering(boolean bl) throws IOException {
            boolean bl2 = this.buffering;
            if (bl != bl2) {
                this.flush();
                this.buffering = bl;
            }
            return bl2;
        }

        @Override
        public void write(int n) throws IOException {
            this.buffer.write(n);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.buffer.write(byArray, n, n2);
        }

        @Override
        public void flush() throws IOException {
            int n = this.buffer.size();
            if (n > 0) {
                if (this.buffering) {
                    if (n < 256) {
                        this.out.write(119);
                        this.out.write(n);
                    } else {
                        this.out.write(122);
                        this.out.write(n >> 24 & 0xFF);
                        this.out.write(n >> 16 & 0xFF);
                        this.out.write(n >> 8 & 0xFF);
                        this.out.write(n & 0xFF);
                    }
                }
                this.buffer.writeTo(this.out);
                this.buffer.reset();
            }
        }

        private /* synthetic */ void Block$() {
            this.buffer = new ByteArrayOutputStream(255);
        }
    }
}

