/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import kaffe.io.CharToByteConverter;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputStreamWriter
extends Writer {
    private static final int BUFDEFAULT = 8192;
    private static final int MINMARGIN = 32;
    private OutputStream strm;
    private CharToByteConverter encoding;
    private byte[] outbuf;
    private int buflen;

    public OutputStreamWriter(OutputStream outputStream) {
        super(outputStream);
        this.Block$();
        this.strm = outputStream;
        this.encoding = CharToByteConverter.getDefault();
    }

    public OutputStreamWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        super(outputStream);
        this.Block$();
        this.strm = outputStream;
        this.encoding = CharToByteConverter.getConverter(string);
    }

    private void checkIfStillOpen() throws IOException {
        if (this.strm == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.strm != null) {
                this.flush();
                this.strm.close();
                this.strm = null;
                this.encoding = null;
                this.outbuf = null;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            if (this.buflen > 0) {
                this.strm.write(this.outbuf, 0, this.buflen);
                this.buflen = 0;
            }
            this.strm.flush();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEncoding() {
        Object object = this.lock;
        synchronized (object) {
            return this.encoding == null ? null : this.encoding.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String string, int n, int n2) throws IOException {
        if (n2 < 0 || n < 0 || n + n2 > string.length()) {
            throw new IndexOutOfBoundsException();
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            super.write(string, n, n2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        if (n2 < 0 || n < 0 || n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            if (n2 > 0) {
                int n3 = this.encoding.convert(cArray, n, n2, this.outbuf, this.buflen, this.outbuf.length - this.buflen);
                if (n3 == 0) {
                    this.flush();
                    n3 = this.encoding.flush(this.outbuf, this.buflen, this.outbuf.length - this.buflen);
                }
                while (n3 > 0) {
                    this.buflen += n3;
                    if (this.outbuf.length - this.buflen < 32) {
                        this.flush();
                    }
                    n3 = this.encoding.flush(this.outbuf, this.buflen, this.outbuf.length - this.buflen);
                }
            }
            return;
        }
    }

    @Override
    public void write(int n) throws IOException {
        super.write(n);
    }

    private /* synthetic */ void Block$() {
        this.outbuf = new byte[8192];
    }
}

