/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.PipedReader;
import java.io.Writer;
import kaffe.io.CircularBuffer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PipedWriter
extends Writer {
    CircularBuffer buffer;

    public PipedWriter() {
    }

    public PipedWriter(PipedReader pipedReader) throws IOException {
        this.connect(pipedReader);
    }

    private void checkIfStillOpen() throws IOException {
        if (this.buffer.isClosed()) {
            throw new IOException("Pipe closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIfConnected() throws IOException {
        PipedWriter pipedWriter = this;
        synchronized (pipedWriter) {
            if (!this.isConnected()) {
                throw new IOException("Pipe not connected");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(PipedReader pipedReader) throws IOException {
        PipedWriter pipedWriter = this;
        synchronized (pipedWriter) {
            pipedReader.connect(this);
            return;
        }
    }

    private boolean isConnected() {
        return this.buffer != null;
    }

    @Override
    public void write(int n) throws IOException {
        super.write(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        this.checkIfConnected();
        CircularBuffer circularBuffer = this.buffer;
        synchronized (circularBuffer) {
            while (n2 > 0) {
                this.checkIfStillOpen();
                if (this.buffer.isFull()) {
                    try {
                        this.buffer.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                int n3 = this.buffer.write(cArray, n, n2);
                n += n3;
                n2 -= n3;
                this.buffer.notify();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        if (this.isConnected()) {
            CircularBuffer circularBuffer = this.buffer;
            synchronized (circularBuffer) {
                this.checkIfStillOpen();
                this.buffer.notify();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        CircularBuffer circularBuffer = this.buffer;
        synchronized (circularBuffer) {
            this.buffer.close();
            this.buffer.notifyAll();
            return;
        }
    }
}

