/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringReader
extends Reader {
    private char[] buf;
    private int pos;
    private int markpos;

    public StringReader(String string) {
        this.buf = string.toCharArray();
    }

    private boolean atEOF() {
        return this.pos == this.buf.length;
    }

    private void checkIfStillOpen() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf != null) {
                this.buf = null;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            this.markpos = this.pos;
            return;
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            if (!this.atEOF()) {
                return this.buf[this.pos++];
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        if (n2 < 0 || n < 0 || n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            if (!this.atEOF()) {
                int n3 = Math.min(n2, this.buf.length - this.pos);
                System.arraycopy(this.buf, this.pos, cArray, n, n3);
                this.pos += n3;
                return n3;
            }
        }
        return -1;
    }

    @Override
    public boolean ready() throws IOException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            this.pos = this.markpos;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long l) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            if (l <= 0L) {
                return 0L;
            }
            long l2 = Math.min(l, (long)(this.buf.length - this.pos));
            this.pos += (int)l2;
            return l2;
        }
    }
}

