/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Byte
extends Number
implements Comparable {
    public static final byte MIN_VALUE = -128;
    public static final byte MAX_VALUE = 127;
    public static final Class TYPE = Class.getPrimitiveClass("byte");
    private final byte value;
    private static final long serialVersionUID = -7183698231559129828L;

    public Byte(String string) throws NumberFormatException {
        this.value = Byte.parseByte(string);
    }

    public Byte(byte by) {
        this.value = by;
    }

    @Override
    public byte byteValue() {
        return this.value;
    }

    public static Byte decode(String string) throws NumberFormatException {
        int n = Integer.decode(string);
        if (n < -128 || n > 127) {
            throw new NumberFormatException(string);
        }
        return new Byte((byte)n);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        return object instanceof Byte && ((Byte)object).value == this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    public static byte parseByte(String string) throws NumberFormatException {
        return Byte.parseByte(string, 10);
    }

    public static byte parseByte(String string, int n) throws NumberFormatException {
        int n2 = Integer.parseInt(string, n);
        if (n2 < -128 || n2 > 127) {
            throw new NumberFormatException(string);
        }
        return (byte)n2;
    }

    public String toString() {
        return Byte.toString(this.value);
    }

    public static String toString(byte by) {
        return Integer.toString(by);
    }

    public static Byte valueOf(String string) throws NumberFormatException {
        return new Byte(Byte.parseByte(string));
    }

    public static Byte valueOf(String string, int n) throws NumberFormatException {
        return new Byte(Byte.parseByte(string, n));
    }

    public int compareTo(Byte by) {
        return this.value - by.value;
    }

    @Override
    public int compareTo(Object object) {
        return this.compareTo((Byte)object);
    }
}

