/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.net.URL;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import kaffe.lang.ThreadStack;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Package {
    private final String name;
    private final String specTitle;
    private final String specVersion;
    private final String specVendor;
    private final String implTitle;
    private final String implVersion;
    private final String implVendor;
    private final URL sealBase;
    private static final String VERSION_DELIMITER = ".";

    Package(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Package name can not be null");
        }
        this.name = string;
        this.specTitle = string2;
        this.specVersion = string3;
        this.specVendor = string4;
        this.implTitle = string5;
        this.implVersion = string6;
        this.implVendor = string7;
        this.sealBase = uRL;
    }

    private static ClassLoader getCallingClassLoader() {
        return ThreadStack.getCallersClassLoader(true);
    }

    public String getImplementationTitle() {
        return this.implTitle;
    }

    public String getImplementationVendor() {
        return this.implVendor;
    }

    public String getImplementationVersion() {
        return this.implVersion;
    }

    public String getName() {
        return this.name;
    }

    public static Package getPackage(String string) {
        return Package.getCallingClassLoader().getPackage(string);
    }

    public static Package[] getPackages() {
        return Package.getCallingClassLoader().getPackages();
    }

    public String getSpecificationTitle() {
        return this.specTitle;
    }

    public String getSpecificationVendor() {
        return this.specVendor;
    }

    public String getSpecificationVersion() {
        return this.specVersion;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean isCompatibleWith(String string) throws NumberFormatException {
        StringTokenizer stringTokenizer = new StringTokenizer(this.getSpecificationVersion(), VERSION_DELIMITER);
        StringTokenizer stringTokenizer2 = new StringTokenizer(string, VERSION_DELIMITER);
        while (stringTokenizer.hasMoreTokens() || stringTokenizer2.hasMoreTokens()) {
            int n;
            int n2;
            String string2;
            try {
                string2 = stringTokenizer.nextToken();
                n2 = Integer.parseInt(string2);
            }
            catch (NoSuchElementException noSuchElementException) {
                n2 = 0;
            }
            try {
                string2 = stringTokenizer2.nextToken();
                n = Integer.parseInt(string2);
            }
            catch (NoSuchElementException noSuchElementException) {
                n = 0;
            }
            if (n2 >= n) continue;
            return false;
        }
        return true;
    }

    public boolean isSealed() {
        return this.sealBase != null;
    }

    public boolean isSealed(URL uRL) {
        return uRL.equals(this.sealBase);
    }
}

