/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import kaffe.util.UTF8;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProcessInputStream
extends FilterInputStream
implements DataInput {
    public ProcessInputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public final int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) throws IOException {
        return super.read(byArray, n, n2);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        int n = super.read();
        if (n == -1) {
            throw new EOFException();
        }
        return (byte)n;
    }

    @Override
    public final char readChar() throws IOException {
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        return (char)(n << 8 | n2);
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.read(byArray, n + n3, n2 + n3);
            if (n4 == -1) {
                throw new EOFException();
            }
            n3 += n4;
        }
    }

    @Override
    public final int readInt() throws IOException {
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        int n3 = this.readUnsignedByte();
        int n4 = this.readUnsignedByte();
        int n5 = n << 24 | n2 << 16 | n3 << 8 | n4;
        return n5;
    }

    @Override
    public final String readLine() throws IOException {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        while (!bl) {
            int n = super.read();
            if (n == -1) {
                bl = true;
                continue;
            }
            stringBuffer.append((byte)n);
            if ((char)n == '\n') {
                bl = true;
            }
            if ((char)n != '\r') continue;
            super.mark(1);
            int n2 = super.read();
            if (n2 == -1) {
                bl = true;
                continue;
            }
            if ((char)n2 == '\n') {
                stringBuffer.append((byte)n2);
                bl = true;
                continue;
            }
            this.reset();
        }
        return stringBuffer.toString();
    }

    @Override
    public final long readLong() throws IOException {
        int n = this.readInt();
        int n2 = this.readInt();
        return (long)n << 32 | (long)n2 & 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public final short readShort() throws IOException {
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        return (short)(n << 8 | n2);
    }

    @Override
    public final String readUTF() throws IOException {
        return UTF8.decode(this, this.readUnsignedShort());
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        int n = super.read();
        if (n == -1) {
            throw new EOFException();
        }
        return n & 0xFF;
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        return n << 8 | n2;
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        long l = super.skip(n);
        int n2 = (int)l;
        if (n2 != n) {
            throw new EOFException();
        }
        return n2;
    }
}

