/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import kaffe.lang.ThreadStack;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Runtime {
    private static Runtime currentRuntime = new Runtime();
    private static kaffe.lang.MemoryAdvice advice = kaffe.lang.MemoryAdvice.getInstance();
    private static final Vector shutdownHooks = new Vector(0);
    private static boolean VMShuttingDown = false;
    private static final RuntimePermission SHUTDOWN_HOOKS = new RuntimePermission("shutdownHooks");

    private Runtime() {
    }

    public Process exec(String string) throws IOException {
        return this.exec(string, null, null);
    }

    public Process exec(String string, String[] stringArray) throws IOException {
        return this.exec(string, stringArray, null);
    }

    public Process exec(String string, String[] stringArray, File file) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        String[] stringArray2 = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray2[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        return this.exec(stringArray2, stringArray, file);
    }

    public Process exec(String[] stringArray) throws IOException {
        return this.exec(stringArray, null, null);
    }

    public Process exec(String[] stringArray, String[] stringArray2) throws IOException {
        return this.exec(stringArray, stringArray2, null);
    }

    public Process exec(String[] stringArray, String[] stringArray2, File file) throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkExec(stringArray[0]);
        }
        return this.execInternal(stringArray, stringArray2, file);
    }

    private native Process execInternal(String[] var1, String[] var2, File var3) throws IOException;

    boolean exitJavaCleanup() {
        return this.runShutdownHooks();
    }

    public void exit(int n) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkExit(n);
        }
        if (!this.exitJavaCleanup()) {
            Thread.currentThread().destroy();
        }
        this.exit0(n);
    }

    public void halt(int n) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkExit(n);
        }
        this.exit0(n);
    }

    private native void exit0(int var1);

    public native long freeMemory();

    public native void gc();

    public InputStream getLocalizedInputStream(InputStream inputStream) {
        return inputStream;
    }

    public OutputStream getLocalizedOutputStream(OutputStream outputStream) {
        return outputStream;
    }

    public static Runtime getRuntime() {
        return currentRuntime;
    }

    public void loadLibrary(String string) {
        this.loadLibrary(string, ThreadStack.getCallersClassLoader(false));
    }

    void loadLibrary(String string, ClassLoader classLoader) {
        String string2;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkLink(string);
        }
        String string3 = new StringBuffer().append(string).append(": not found").toString();
        String[] stringArray = classLoader != null && (string2 = classLoader.findLibrary(string)) != null ? new String[]{string2} : NativeLibrary.getLibraryNames(string);
        int n = 0;
        while (n < stringArray.length) {
            try {
                new NativeLibrary(stringArray[n], classLoader);
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                string3 = unsatisfiedLinkError.getMessage();
            }
            ++n;
        }
        throw new UnsatisfiedLinkError(new StringBuffer().append(string3).append("\nAdding its directory to LD_LIBRARY_PATH may help.").toString());
    }

    public void load(String string) {
        this.load(string, ThreadStack.getCallersClassLoader(false));
    }

    void load(String string, ClassLoader classLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkLink(string);
        }
        try {
            new NativeLibrary(string, classLoader);
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new UnsatisfiedLinkError(new StringBuffer().append(string).append(": not found").toString());
        }
    }

    int getMemoryAdvice() {
        return advice.getColor();
    }

    int waitForMemoryAdvice(int n) throws InterruptedException {
        return advice.waitForOtherColor(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runShutdownHooks() {
        Thread thread;
        Runtime runtime = this;
        synchronized (runtime) {
            if (VMShuttingDown) {
                return false;
            }
            VMShuttingDown = true;
        }
        Enumeration enumeration = shutdownHooks.elements();
        while (enumeration.hasMoreElements()) {
            thread = (Thread)enumeration.nextElement();
            try {
                thread.start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        enumeration = shutdownHooks.elements();
        while (enumeration.hasMoreElements()) {
            thread = (Thread)enumeration.nextElement();
            try {
                thread.join();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShutdownHook(Thread thread) throws IllegalArgumentException, IllegalStateException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SHUTDOWN_HOOKS);
        }
        Runtime runtime = this;
        synchronized (runtime) {
            if (VMShuttingDown) {
                throw new IllegalStateException("VM is shutting down.");
            }
        }
        if (thread.isAlive() || thread.isInterrupted() || thread.hasDied()) {
            throw new IllegalArgumentException("Thread has already been started once.");
        }
        Vector vector = shutdownHooks;
        synchronized (vector) {
            if (shutdownHooks.contains(thread)) {
                throw new IllegalArgumentException("Thread already in shutdown queue.");
            }
            shutdownHooks.addElement(thread);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeShutdownHook(Thread thread) throws IllegalStateException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SHUTDOWN_HOOKS);
        }
        Runtime runtime = this;
        synchronized (runtime) {
            if (VMShuttingDown) {
                throw new IllegalStateException("VM is shutting down.");
            }
        }
        return shutdownHooks.removeElement(thread);
    }

    public native void runFinalization();

    public static native void runFinalizersOnExit(boolean var0);

    public native long totalMemory();

    public native void traceInstructions(boolean var1);

    public native void traceMethodCalls(boolean var1);

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface MemoryAdvice {
        public static final int GREEN = 0;
        public static final int YELLOW = 1;
        public static final int ORANGE = 2;
        public static final int RED = 3;
    }
}

