/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import kaffe.util.Deprecated;
import kaffe.util.Ptr;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Thread
implements Runnable {
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;
    private static final RuntimePermission sccl = new RuntimePermission("setContextClassLoader");
    private static int threadCount;
    private char[] name;
    private int priority;
    private Thread threadQ;
    private Ptr PrivateInfo;
    private Ptr sFunc;
    private Ptr sArg;
    private boolean daemon;
    private boolean interrupting;
    private Runnable target;
    private ThreadGroup group;
    private Ptr exceptPtr;
    private Throwable exceptObj;
    private Ptr jnireferences;
    private Throwable stackOverflowError;
    private Throwable outOfMemoryError;
    private boolean started;
    private boolean dying;
    private HashMap threadLocals;
    private Object suspendResume;
    private Object sleeper;
    private Object holder;
    private Ptr sem;
    private Thread nextlk;
    private Throwable death;
    private int needOnStack;
    private ClassLoader context;

    public Thread() {
        this(null, null, Thread.generateName());
    }

    public Thread(Runnable runnable) {
        this(null, runnable, Thread.generateName());
    }

    public Thread(Runnable runnable, String string) {
        this(null, runnable, string);
    }

    public Thread(String string) {
        this(null, null, string);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable) {
        this(threadGroup, runnable, Thread.generateName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread(ThreadGroup threadGroup, Runnable runnable, String string) {
        int n;
        int n2;
        Thread thread = Thread.currentThread();
        this.group = threadGroup == null ? thread.getThreadGroup() : threadGroup;
        this.group.checkAccess();
        this.group.add(this);
        this.name = string.toCharArray();
        this.target = runnable;
        this.interrupting = false;
        this.stackOverflowError = new StackOverflowError();
        this.outOfMemoryError = new OutOfMemoryError();
        if (thread.threadLocals != null) {
            HashMap hashMap = thread.threadLocals;
            synchronized (hashMap) {
                Iterator iterator = thread.threadLocals.keySet().iterator();
                while (iterator.hasNext()) {
                    try {
                        InheritableThreadLocal inheritableThreadLocal = (InheritableThreadLocal)iterator.next();
                        inheritableThreadLocal.set(this, inheritableThreadLocal.childValue(inheritableThreadLocal.get()));
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            }
        }
        if ((n2 = thread.getPriority()) < (n = this.group.getMaxPriority())) {
            this.setPriority0(n2);
        } else {
            this.setPriority0(n);
        }
        this.setDaemon(thread.isDaemon());
        this.context = thread.getContextClassLoader();
    }

    public Thread(ThreadGroup threadGroup, String string) {
        this(threadGroup, null, string);
    }

    public static int activeCount() {
        return Thread.currentThread().getThreadGroup().activeCount();
    }

    public void checkAccess() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkAccess(this);
        }
    }

    public int countStackFrames() {
        return 0;
    }

    public static native Thread currentThread();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Thread thread = this;
        synchronized (thread) {
            this.dying = true;
            this.notifyAll();
        }
        if (this.group != null) {
            this.group.remove(this);
        }
        this.destroy0();
    }

    private native void destroy0();

    public static void dumpStack() {
        Throwable throwable = new Throwable();
        throwable.printStackTrace();
    }

    public static int enumerate(Thread[] threadArray) {
        return Thread.currentThread().getThreadGroup().enumerate(threadArray);
    }

    protected void finalize() throws Throwable {
        this.finalize0();
        super.finalize();
    }

    private final native void finalize0();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finish() {
        ThreadGroup threadGroup;
        Thread thread = this;
        synchronized (thread) {
            this.dying = true;
            this.notifyAll();
            threadGroup = this.group;
            this.group = null;
        }
        if (threadGroup != null) {
            threadGroup.remove(this);
        }
    }

    private static String generateName() {
        return new String(new StringBuffer().append("Thread-").append(threadCount++).toString());
    }

    public final String getName() {
        return new String(this.name);
    }

    public final int getPriority() {
        return this.priority;
    }

    public final ThreadGroup getThreadGroup() {
        return this.group;
    }

    synchronized HashMap getThreadLocals() {
        if (this.threadLocals == null) {
            this.threadLocals = new HashMap();
        }
        return this.threadLocals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        this.interrupting = true;
        Object object = this.holder;
        if (object != null) {
            this.holder = null;
            Object object2 = object;
            synchronized (object2) {
                object.notify();
                return;
            }
        }
        this.interrupt0();
    }

    private native void interrupt0();

    public static boolean interrupted() {
        Thread thread = Thread.currentThread();
        boolean bl = thread.interrupting;
        thread.interrupting = false;
        return bl;
    }

    final boolean hasDied() {
        return this.dying;
    }

    public final boolean isAlive() {
        return this.started && !this.dying;
    }

    public final boolean isDaemon() {
        return this.daemon;
    }

    public boolean isInterrupted() {
        return this.interrupting;
    }

    public final void join() throws InterruptedException {
        this.join(0L);
    }

    public final synchronized void join(long l) throws InterruptedException {
        this.join(l, 0);
    }

    public final synchronized void join(long l, int n) throws InterruptedException {
        Thread thread = Thread.currentThread();
        if (l == 0L && n == 0) {
            while (this.isAlive()) {
                thread.waitOn(this, 0L);
            }
            return;
        }
        long l2 = System.currentTimeMillis() + l;
        while (true) {
            long l3 = l2 - System.currentTimeMillis();
            if (!this.isAlive()) break;
            if (l3 <= 0L) {
                return;
            }
            thread.waitOn(this, l3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume() {
        if (this.suspendResume != null) {
            Object object = this.suspendResume;
            synchronized (object) {
                this.suspendResume.notifyAll();
                return;
            }
        }
    }

    @Override
    public void run() {
        if (this.target != null) {
            this.target.run();
        }
    }

    public final synchronized void setDaemon(boolean bl) {
        if (this.started) {
            throw new IllegalThreadStateException("Active Thread");
        }
        this.daemon = bl;
    }

    public final void setName(String string) {
        this.name = string.toCharArray();
    }

    public final void setPriority(int n) {
        this.checkAccess();
        if (n < 1 || n > 10) {
            throw new IllegalArgumentException(new StringBuffer().append("Priority: ").append(n).toString());
        }
        if (n > this.group.getMaxPriority()) {
            n = this.group.getMaxPriority();
        }
        this.setPriority0(n);
    }

    private native void setPriority0(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sleep(long l) throws InterruptedException {
        Thread thread = Thread.currentThread();
        if (thread.sleeper == null) {
            thread.sleeper = new Sleeper();
        }
        if (l == 0L) {
            l = 1L;
        }
        Object object = thread.sleeper;
        synchronized (object) {
            thread.waitOn(thread.sleeper, l);
            return;
        }
    }

    public static void sleep(long l, int n) throws InterruptedException {
        Thread.sleep(l);
    }

    public synchronized void start() {
        if (this.dying) {
            throw new IllegalThreadStateException("Dead Thread");
        }
        if (this.started) {
            throw new IllegalThreadStateException("Active Thread");
        }
        this.started = true;
        this.start0();
    }

    public native void start0();

    public final void stop() {
        this.stop(new ThreadDeath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void stop(Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException();
        }
        this.death = throwable;
        Object object = this.holder;
        if (object != null) {
            this.holder = null;
            Object object2 = object;
            synchronized (object2) {
                object.notify();
                return;
            }
        }
        this.stop0(throwable);
    }

    private native void stop0(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void suspend() {
        if (this.suspendResume == null) {
            this.suspendResume = new Suspender();
        }
        if (Thread.currentThread() != this) {
            throw new Deprecated("suspending of other threads not supported");
        }
        Object object = this.suspendResume;
        synchronized (object) {
            while (true) {
                try {
                    Object object2 = this.suspendResume;
                    synchronized (object2) {
                        this.waitOn(this.suspendResume, 0L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            return;
        }
    }

    public String toString() {
        return new String(new StringBuffer().append("Thread[").append(this.getName()).append(",").append(this.getPriority()).append(",").append(this.getThreadGroup().getName()).append("]").toString());
    }

    void waitOn(Object object, long l) throws InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException("timeout is negative");
        }
        if (this.interrupting) {
            this.interrupting = false;
            throw new InterruptedException();
        }
        if (this.death != null) {
            Error error = (Error)this.death;
            this.death = null;
            error.fillInStackTrace();
            throw error;
        }
        this.holder = object;
        object.wait0(l);
        this.holder = null;
        if (this.interrupting) {
            this.interrupting = false;
            throw new InterruptedException();
        }
        if (this.death != null) {
            Error error = (Error)this.death;
            this.death = null;
            error.fillInStackTrace();
            throw error;
        }
    }

    public static void yield() {
        Thread.yield0();
        Thread thread = Thread.currentThread();
        if (thread.death != null) {
            Error error = (Error)thread.death;
            thread.death = null;
            error.fillInStackTrace();
            throw error;
        }
    }

    public static native void yield0();

    public ClassLoader getContextClassLoader() {
        return this.context;
    }

    public void setContextClassLoader(ClassLoader classLoader) {
        AccessController.checkPermission(sccl);
        this.context = classLoader;
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Sleeper {
        private Sleeper() {
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Suspender {
        private Suspender() {
        }
    }
}

