/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Throwable
implements Serializable {
    private static final long serialVersionUID = -3042686055658047285L;
    private final String detailMessage;
    private Throwable cause;
    private StackTraceElement[] stackTrace;
    private static final String nl = System.getProperty("line.separator");
    private transient VMThrowable vmState;

    public Throwable() {
        this((String)null);
    }

    public Throwable(String string) {
        this.Block$();
        this.fillInStackTrace();
        this.detailMessage = string;
    }

    public Throwable(String string, Throwable throwable) {
        this(string);
        this.initCause(throwable);
    }

    public Throwable(Throwable throwable) {
        this(throwable == null ? null : throwable.toString(), throwable);
    }

    public String getMessage() {
        return this.detailMessage;
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public Throwable getCause() {
        if (this.cause == this) {
            return null;
        }
        return this.cause;
    }

    public Throwable initCause(Throwable throwable) {
        if (throwable == this) {
            throw new IllegalArgumentException();
        }
        if (this.cause != this) {
            throw new IllegalStateException();
        }
        this.cause = throwable;
        return this;
    }

    public String toString() {
        String string = this.getLocalizedMessage();
        return new StringBuffer().append(this.getClass().getName()).append(string == null ? "" : new StringBuffer().append(": ").append(string).toString()).toString();
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream printStream) {
        printStream.print(this.stackTraceString());
    }

    public void printStackTrace(PrintWriter printWriter) {
        printWriter.print(this.stackTraceString());
    }

    private String stackTraceString() {
        StringBuffer stringBuffer = new StringBuffer();
        StackTraceElement[] stackTraceElementArray = this.getStackTrace();
        Throwable.stackTraceStringBuffer(stringBuffer, this.toString(), stackTraceElementArray, 0);
        Throwable throwable = this.getCause();
        while (throwable != null) {
            stringBuffer.append("Caused by: ");
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
            stackTraceElementArray = throwable.getStackTrace();
            if (stackTraceElementArray2 == null || stackTraceElementArray2.length == 0) {
                Throwable.stackTraceStringBuffer(stringBuffer, throwable.toString(), stackTraceElementArray, 0);
            } else {
                int n = 0;
                int n2 = stackTraceElementArray.length - 1;
                int n3 = stackTraceElementArray2.length - 1;
                while (n2 > 0 && n3 > 0) {
                    if (!stackTraceElementArray[n2].equals(stackTraceElementArray2[n3])) break;
                    ++n;
                    --n2;
                    --n3;
                }
                Throwable.stackTraceStringBuffer(stringBuffer, throwable.toString(), stackTraceElementArray, n);
            }
            throwable = throwable.getCause();
        }
        return stringBuffer.toString();
    }

    private static void stackTraceStringBuffer(StringBuffer stringBuffer, String string, StackTraceElement[] stackTraceElementArray, int n) {
        stringBuffer.append(string);
        stringBuffer.append(nl);
        if (stackTraceElementArray == null || stackTraceElementArray.length == 0) {
            stringBuffer.append("   <<No stacktrace available>>");
            stringBuffer.append(nl);
            return;
        }
        int n2 = 0;
        while (n2 < stackTraceElementArray.length - n) {
            stringBuffer.append("   at ");
            stringBuffer.append(stackTraceElementArray[n2] == null ? "<<Unknown>>" : stackTraceElementArray[n2].toString());
            stringBuffer.append(nl);
            ++n2;
        }
        if (n > 0) {
            stringBuffer.append("   ...");
            stringBuffer.append(n);
            stringBuffer.append(" more");
            stringBuffer.append(nl);
        }
    }

    public Throwable fillInStackTrace() {
        this.vmState = VMThrowable.fillInStackTrace(this);
        this.stackTrace = null;
        return this;
    }

    public StackTraceElement[] getStackTrace() {
        if (this.stackTrace == null) {
            if (this.vmState == null) {
                this.stackTrace = new StackTraceElement[0];
            } else {
                this.stackTrace = this.vmState.getStackTrace(this);
                this.vmState = null;
            }
        }
        return this.stackTrace;
    }

    public void setStackTrace(StackTraceElement[] stackTraceElementArray) {
        int n = stackTraceElementArray.length;
        StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[n];
        while (--n >= 0) {
            stackTraceElementArray2[n] = stackTraceElementArray[n];
            if (stackTraceElementArray2[n] != null) continue;
            throw new NullPointerException(new StringBuffer().append("Element ").append(n).append(" null").toString());
        }
        this.stackTrace = stackTraceElementArray2;
    }

    private /* synthetic */ void Block$() {
        this.cause = this;
    }
}

