/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.ReflectPermission;
import java.security.Permission;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessibleObject {
    private static final Permission suppressAccessChecks = new ReflectPermission("suppressAccessChecks");
    private boolean accessible;

    protected AccessibleObject() {
    }

    public boolean isAccessible() {
        return this.accessible;
    }

    public void setAccessible(boolean bl) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(suppressAccessChecks);
        }
        AccessibleObject.setAccessible0(this, bl);
    }

    public static void setAccessible(AccessibleObject[] accessibleObjectArray, boolean bl) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(suppressAccessChecks);
        }
        int n = 0;
        while (n < accessibleObjectArray.length) {
            AccessibleObject.setAccessible0(accessibleObjectArray[n], bl);
            ++n;
        }
    }

    private static void setAccessible0(AccessibleObject accessibleObject, boolean bl) throws SecurityException {
        if (bl && accessibleObject instanceof Constructor && ((Constructor)accessibleObject).getDeclaringClass() == Class.forName("java.lang.Class")) {
            throw new SecurityException("Can't change accessibility of java.lang.Class constructor");
        }
        accessibleObject.accessible = bl;
    }
}

