/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Field
extends AccessibleObject
implements Member {
    private Class clazz;
    private int slot;
    private String name;
    private Class type;

    private Field() {
    }

    private void checkFinal() throws IllegalAccessException {
        if (Modifier.isFinal(this.getModifiers())) {
            throw new IllegalAccessException(new StringBuffer().append("trying to set final field ").append(this.toString()).toString());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Field)) {
            return false;
        }
        Field field = (Field)object;
        return this.clazz == field.clazz && this.type == field.type && this.name.equals(field.name);
    }

    public Object get(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (this.type == Double.TYPE) {
            return new Double(this.getDouble0(object));
        }
        if (this.type == Float.TYPE) {
            return new Float(this.getFloat0(object));
        }
        if (this.type == Long.TYPE) {
            return new Long(this.getLong0(object));
        }
        if (this.type == Integer.TYPE) {
            return new Integer(this.getInt0(object));
        }
        if (this.type == Short.TYPE) {
            return new Short(this.getShort0(object));
        }
        if (this.type == Byte.TYPE) {
            return new Byte(this.getByte0(object));
        }
        if (this.type == Character.TYPE) {
            return new Character(this.getChar0(object));
        }
        if (this.type == Boolean.TYPE) {
            return new Boolean(this.getBoolean0(object));
        }
        return this.getObject0(object);
    }

    public boolean getBoolean(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (this.type == Boolean.TYPE) {
            return this.getBoolean0(object);
        }
        throw new IllegalArgumentException();
    }

    public byte getByte(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (this.type == Byte.TYPE) {
            return this.getByte0(object);
        }
        throw new IllegalArgumentException();
    }

    public char getChar(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (this.type == Character.TYPE) {
            return this.getChar0(object);
        }
        throw new IllegalArgumentException();
    }

    public double getDouble(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (this.type == Double.TYPE) {
            return this.getDouble0(object);
        }
        if (this.type == Float.TYPE) {
            return this.getFloat0(object);
        }
        if (this.type == Long.TYPE) {
            return this.getLong0(object);
        }
        if (this.type == Integer.TYPE) {
            return this.getInt0(object);
        }
        if (this.type == Short.TYPE) {
            return this.getShort0(object);
        }
        if (this.type == Byte.TYPE) {
            return this.getByte0(object);
        }
        if (this.type == Character.TYPE) {
            return this.getChar0(object);
        }
        throw new IllegalArgumentException();
    }

    public float getFloat(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (this.type == Float.TYPE) {
            return this.getFloat0(object);
        }
        if (this.type == Long.TYPE) {
            return this.getLong0(object);
        }
        if (this.type == Integer.TYPE) {
            return this.getInt0(object);
        }
        if (this.type == Short.TYPE) {
            return this.getShort0(object);
        }
        if (this.type == Byte.TYPE) {
            return this.getByte0(object);
        }
        if (this.type == Character.TYPE) {
            return this.getChar0(object);
        }
        throw new IllegalArgumentException();
    }

    public int getInt(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (this.type == Integer.TYPE) {
            return this.getInt0(object);
        }
        if (this.type == Short.TYPE) {
            return this.getShort0(object);
        }
        if (this.type == Byte.TYPE) {
            return this.getByte0(object);
        }
        if (this.type == Character.TYPE) {
            return this.getChar0(object);
        }
        throw new IllegalArgumentException();
    }

    public long getLong(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (this.type == Long.TYPE) {
            return this.getLong0(object);
        }
        if (this.type == Integer.TYPE) {
            return this.getInt0(object);
        }
        if (this.type == Short.TYPE) {
            return this.getShort0(object);
        }
        if (this.type == Byte.TYPE) {
            return this.getByte0(object);
        }
        if (this.type == Character.TYPE) {
            return this.getChar0(object);
        }
        throw new IllegalArgumentException();
    }

    public short getShort(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (this.type == Short.TYPE) {
            return this.getShort0(object);
        }
        if (this.type == Integer.TYPE) {
            return (short)this.getInt0(object);
        }
        if (this.type == Long.TYPE) {
            return (short)this.getLong0(object);
        }
        if (this.type == Float.TYPE) {
            return (short)this.getFloat0(object);
        }
        if (this.type == Double.TYPE) {
            return (short)this.getDouble0(object);
        }
        throw new IllegalArgumentException();
    }

    public void set(Object object, Object object2) throws IllegalArgumentException, IllegalAccessException {
        this.checkFinal();
        if (this.type.isPrimitive()) {
            if (object2 instanceof Boolean) {
                this.setBoolean(object, (Boolean)object2);
                return;
            }
            if (object2 instanceof Byte) {
                this.setByte(object, (Byte)object2);
                return;
            }
            if (object2 instanceof Short) {
                this.setShort(object, (Short)object2);
                return;
            }
            if (object2 instanceof Character) {
                this.setChar(object, ((Character)object2).charValue());
                return;
            }
            if (object2 instanceof Integer) {
                this.setInt(object, (Integer)object2);
                return;
            }
            if (object2 instanceof Long) {
                this.setLong(object, (Long)object2);
                return;
            }
            if (object2 instanceof Float) {
                this.setFloat(object, ((Float)object2).floatValue());
                return;
            }
            this.setDouble(object, (Double)object2);
            return;
        }
        if (!this.type.isInstance(object2)) {
            throw new IllegalArgumentException(new StringBuffer().append("field type mismatch: Trying to assign a ").append(object2.getClass().getName()).append(" to ").append(this.toString()).toString());
        }
        this.setObject0(object, object2);
    }

    public void setBoolean(Object object, boolean bl) throws IllegalArgumentException, IllegalAccessException {
        if (this.type == Boolean.TYPE) {
            this.setBoolean0(object, bl);
            return;
        }
        throw new IllegalArgumentException();
    }

    public void setByte(Object object, byte by) throws IllegalArgumentException, IllegalAccessException {
        if (this.type == Byte.TYPE) {
            this.setByte0(object, by);
            return;
        }
        if (this.type == Short.TYPE) {
            this.setShort0(object, by);
            return;
        }
        if (this.type == Integer.TYPE) {
            this.setInt0(object, by);
            return;
        }
        if (this.type == Long.TYPE) {
            this.setLong0(object, by);
            return;
        }
        if (this.type == Float.TYPE) {
            this.setFloat0(object, by);
            return;
        }
        if (this.type == Double.TYPE) {
            this.setDouble0(object, by);
            return;
        }
        throw new IllegalArgumentException();
    }

    public void setChar(Object object, char c) throws IllegalArgumentException, IllegalAccessException {
        if (this.type == Character.TYPE) {
            this.setChar0(object, c);
            return;
        }
        if (this.type == Integer.TYPE) {
            this.setInt0(object, c);
            return;
        }
        if (this.type == Long.TYPE) {
            this.setLong0(object, c);
            return;
        }
        if (this.type == Float.TYPE) {
            this.setFloat0(object, c);
            return;
        }
        if (this.type == Double.TYPE) {
            this.setDouble0(object, c);
            return;
        }
        throw new IllegalArgumentException();
    }

    public void setDouble(Object object, double d) throws IllegalArgumentException, IllegalAccessException {
        if (this.type == Double.TYPE) {
            this.setDouble0(object, d);
            return;
        }
        throw new IllegalArgumentException();
    }

    public void setFloat(Object object, float f) throws IllegalArgumentException, IllegalAccessException {
        if (this.type == Float.TYPE) {
            this.setFloat0(object, f);
            return;
        }
        if (this.type == Double.TYPE) {
            this.setDouble0(object, f);
            return;
        }
        throw new IllegalArgumentException();
    }

    public void setInt(Object object, int n) throws IllegalArgumentException, IllegalAccessException {
        if (this.type == Integer.TYPE) {
            this.setInt0(object, n);
            return;
        }
        if (this.type == Long.TYPE) {
            this.setLong0(object, n);
            return;
        }
        if (this.type == Float.TYPE) {
            this.setFloat0(object, n);
            return;
        }
        if (this.type == Double.TYPE) {
            this.setDouble0(object, n);
            return;
        }
        throw new IllegalArgumentException();
    }

    public void setLong(Object object, long l) throws IllegalArgumentException, IllegalAccessException {
        if (this.type == Long.TYPE) {
            this.setLong0(object, l);
            return;
        }
        if (this.type == Float.TYPE) {
            this.setFloat0(object, l);
            return;
        }
        if (this.type == Double.TYPE) {
            this.setDouble0(object, l);
            return;
        }
        throw new IllegalArgumentException();
    }

    public void setShort(Object object, short s) throws IllegalArgumentException, IllegalAccessException {
        if (this.type == Short.TYPE) {
            this.setShort0(object, s);
            return;
        }
        if (this.type == Integer.TYPE) {
            this.setInt0(object, s);
            return;
        }
        if (this.type == Long.TYPE) {
            this.setLong0(object, s);
            return;
        }
        if (this.type == Float.TYPE) {
            this.setFloat0(object, s);
            return;
        }
        if (this.type == Double.TYPE) {
            this.setDouble0(object, s);
            return;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Class getDeclaringClass() {
        return this.clazz;
    }

    @Override
    public native int getModifiers();

    @Override
    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public int hashCode() {
        return this.clazz.getName().hashCode() ^ this.name.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getModifiers();
        if (n != 0) {
            stringBuffer.append(Modifier.toString(n));
            stringBuffer.append(' ');
        }
        stringBuffer.append(Method.getPrettyName(this.type));
        stringBuffer.append(' ');
        stringBuffer.append(this.clazz.getName());
        stringBuffer.append('.');
        stringBuffer.append(this.name);
        return stringBuffer.toString();
    }

    private native boolean getBoolean0(Object var1);

    private native byte getByte0(Object var1);

    private native char getChar0(Object var1);

    private native short getShort0(Object var1);

    private native int getInt0(Object var1);

    private native long getLong0(Object var1);

    private native float getFloat0(Object var1);

    private native double getDouble0(Object var1);

    private native Object getObject0(Object var1);

    private native void setBoolean0(Object var1, boolean var2);

    private native void setByte0(Object var1, byte var2);

    private native void setChar0(Object var1, char var2);

    private native void setShort0(Object var1, short var2);

    private native void setInt0(Object var1, int var2);

    private native void setLong0(Object var1, long var2);

    private native void setFloat0(Object var1, float var2);

    private native void setDouble0(Object var1, double var2);

    private native void setObject0(Object var1, Object var2);
}

