/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Inet6Address
extends InetAddress {
    static final long serialVersionUID = 6880410070516793377L;
    private static final byte[] ANY_LOCAL = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] LOOPBACK = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
    byte[] ipaddress;

    private static boolean compareAddresses(byte[] byArray, byte[] byArray2) {
        boolean bl = true;
        int n = 0;
        while (n < byArray.length && bl) {
            bl = byArray[n] == byArray2[n];
            ++n;
        }
        return bl;
    }

    protected Inet6Address(byte[] byArray, String string) {
        super(byArray, string);
        this.ipaddress = byArray;
    }

    @Override
    public boolean isMulticastAddress() {
        return this.ipaddress[0] == 255;
    }

    @Override
    public boolean isAnyLocalAddress() {
        return Inet6Address.compareAddresses(this.ipaddress, ANY_LOCAL);
    }

    @Override
    public boolean isLoopbackAddress() {
        return Inet6Address.compareAddresses(this.ipaddress, LOOPBACK);
    }

    @Override
    public boolean isLinkLocalAddress() {
        return this.ipaddress[0] == 250;
    }

    @Override
    public boolean isSiteLocalAddress() {
        return this.ipaddress[0] == 251;
    }

    @Override
    public boolean isMCGlobal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        return (this.ipaddress[1] & 0xF) == 14;
    }

    @Override
    public boolean isMCNodeLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        return (this.ipaddress[1] & 0xF) == 1;
    }

    @Override
    public boolean isMCLinkLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        return (this.ipaddress[1] & 0xF) == 2;
    }

    @Override
    public boolean isMCSiteLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        return (this.ipaddress[1] & 0xF) == 5;
    }

    @Override
    public boolean isMCOrgLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        return (this.ipaddress[1] & 0xF) == 8;
    }

    @Override
    public byte[] getAddress() {
        return this.ipaddress;
    }

    @Override
    public String getHostAddress() {
        StringBuffer stringBuffer = new StringBuffer(40);
        int n = 0;
        while (n < 16) {
            boolean bl;
            int n2 = (this.ipaddress[n] & 0xFF) << 8 | this.ipaddress[n + 1] & 0xFF;
            boolean bl2 = bl = stringBuffer.length() == 0;
            if (bl) {
                if (n > 0) {
                    stringBuffer.append("::");
                }
            } else {
                stringBuffer.append(':');
            }
            if (n2 != 0 || n >= 14) {
                stringBuffer.append(Integer.toHexString(n2));
            }
            n += 2;
        }
        return stringBuffer.toString();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof Inet6Address)) {
            return false;
        }
        Inet6Address inet6Address = (Inet6Address)object;
        return super.equals(inet6Address) && Inet6Address.compareAddresses(this.ipaddress, inet6Address.ipaddress);
    }

    public boolean isIPv4CompatibleAddress() {
        return this.ipaddress[0] == 0 && this.ipaddress[1] == 0 && this.ipaddress[2] == 0 && this.ipaddress[3] == 0 && this.ipaddress[4] == 0 && this.ipaddress[5] == 0 && this.ipaddress[6] == 0 && this.ipaddress[7] == 0 && this.ipaddress[8] == 0 && this.ipaddress[9] == 0 && this.ipaddress[10] == 0 && this.ipaddress[11] == 0;
    }
}

