/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MulticastSocket
extends DatagramSocket {
    private InetAddress iface;
    private NetworkInterface ni;

    public MulticastSocket() throws IOException {
        this(0);
    }

    public MulticastSocket(int n) throws IOException {
        super(n, null);
    }

    private static void checkMulticastAddress(InetAddress inetAddress) throws IOException {
        if (inetAddress == null) {
            throw new IllegalArgumentException("Null multicast address");
        }
        if (!inetAddress.isMulticastAddress()) {
            throw new IOException(new StringBuffer().append("InetAddress ").append(inetAddress).append(" is not a multicast address").toString());
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMulticast(inetAddress);
        }
    }

    private static void checkMulticastAddress(SocketAddress socketAddress) throws IOException {
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException(new StringBuffer().append("Unknown SocketAddress type: ").append(socketAddress.getClass().getName()).toString());
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        MulticastSocket.checkMulticastAddress(inetSocketAddress.getAddress());
    }

    @Override
    protected void init(int n, InetAddress inetAddress) throws SocketException {
        this.impl.setOption(4, new Boolean(true));
        super.init(n, inetAddress);
    }

    public int getTimeToLive() throws IOException {
        return this.getTTL();
    }

    public byte getTTL() throws IOException {
        return this.impl.getTTL();
    }

    public void joinGroup(InetAddress inetAddress) throws IOException {
        MulticastSocket.checkMulticastAddress(inetAddress);
        this.impl.joinGroup(new InetSocketAddress(inetAddress, 0), this.ni);
    }

    public void leaveGroup(InetAddress inetAddress) throws IOException {
        MulticastSocket.checkMulticastAddress(inetAddress);
        this.impl.leaveGroup(new InetSocketAddress(inetAddress, 0), this.ni);
    }

    public void joinGroup(SocketAddress socketAddress, NetworkInterface networkInterface) throws IOException {
        MulticastSocket.checkMulticastAddress(socketAddress);
        this.impl.joinGroup(socketAddress, networkInterface);
    }

    public void leaveGroup(SocketAddress socketAddress, NetworkInterface networkInterface) throws IOException {
        MulticastSocket.checkMulticastAddress(socketAddress);
        this.impl.leaveGroup(socketAddress, networkInterface);
    }

    public synchronized void send(DatagramPacket datagramPacket, byte by) throws IOException {
        MulticastSocket.checkMulticastAddress(datagramPacket.getAddress());
        byte by2 = this.getTTL();
        this.setTTL(by);
        super.send(datagramPacket);
        this.setTTL(by2);
    }

    public void setInterface(InetAddress inetAddress) throws SocketException {
        this.iface = inetAddress;
        this.ni = NetworkInterface.getByInetAddress(inetAddress);
        this.impl.setOption(16, this.iface);
    }

    public InetAddress getInterface() throws SocketException {
        return this.iface;
    }

    public void setNetworkInterface(NetworkInterface networkInterface) throws SocketException {
        this.ni = networkInterface;
        this.iface = this.ni.getPrimaryAddress();
        this.impl.setOption(16, this.iface);
    }

    public NetworkInterface getNetworkInterface() {
        return this.ni;
    }

    public void setTimeToLive(int n) throws IOException {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("ttl out of range");
        }
        this.setTTL((byte)n);
    }

    public void setTTL(byte by) throws IOException {
        this.impl.setTTL(by);
    }
}

