/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.net.NetworkInterfaceImpl;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NetworkInterface {
    private final String name;
    private final String displayName;
    private InetAddress primaryAddress;
    private final Vector inetAddresses;

    public static NetworkInterface getByName(String string) throws SocketException {
        NetworkInterfaceImpl networkInterfaceImpl = new NetworkInterfaceImpl();
        NetworkInterface networkInterface = (NetworkInterface)networkInterfaceImpl.getDetectedInterfaces().get(string);
        return networkInterface;
    }

    public static NetworkInterface getByInetAddress(InetAddress inetAddress) throws SocketException {
        NetworkInterfaceImpl networkInterfaceImpl = new NetworkInterfaceImpl();
        NetworkInterface networkInterface = null;
        String string = networkInterfaceImpl.nameForAddress(inetAddress);
        if (string != null) {
            networkInterface = (NetworkInterface)networkInterfaceImpl.getDetectedInterfaces().get(string);
        }
        return networkInterface;
    }

    public static Enumeration getNetworkInterfaces() throws SocketException {
        NetworkInterfaceImpl networkInterfaceImpl = new NetworkInterfaceImpl();
        Enumeration enumeration = null;
        if (networkInterfaceImpl.getDetectedInterfaces().size() > 0) {
            enumeration = networkInterfaceImpl.getDetectedInterfaces().elements();
        }
        return enumeration;
    }

    NetworkInterface(String string, String string2) {
        this.Block$();
        this.name = string;
        this.displayName = string2;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    void setPrimaryAddress(InetAddress inetAddress) {
        this.primaryAddress = inetAddress;
    }

    InetAddress getPrimaryAddress() {
        return this.primaryAddress;
    }

    Vector getInetAddressesInternal() {
        return this.inetAddresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getInetAddresses() {
        Enumeration enumeration = null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            Vector vector = new Vector();
            Vector vector2 = this.inetAddresses;
            synchronized (vector2) {
                int n = this.inetAddresses.size();
                int n2 = 0;
                while (n2 < n) {
                    InetAddress inetAddress = (InetAddress)this.inetAddresses.elementAt(n2);
                    try {
                        securityManager.checkConnect(inetAddress.getHostName(), -1);
                        vector.addElement(inetAddress);
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    ++n2;
                }
            }
            enumeration = vector.elements();
        } else {
            enumeration = this.inetAddresses.elements();
        }
        return enumeration;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof NetworkInterface) {
            NetworkInterface networkInterface = (NetworkInterface)object;
            bl = this.name.equals(networkInterface.name);
        }
        return bl;
    }

    public String toString() {
        return new StringBuffer().append("NetworkInterface[name=").append(this.name).append("; inetAddresses=").append(this.inetAddresses).append("]").toString();
    }

    private /* synthetic */ void Block$() {
        this.inetAddresses = new Vector();
    }
}

