/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Hashtable;
import kaffe.util.Ptr;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
class NetworkInterfaceImpl {
    private final Hashtable detectedInterfaces;
    private final Hashtable addressToName;

    private static native Ptr detectInterfaces() throws SocketException;

    private static native void freeInterfaces(Ptr var0);

    private static native Ptr getNext(Ptr var0);

    private static native String getName(Ptr var0);

    private static native String getIPAddress(Ptr var0);

    NetworkInterfaceImpl() throws SocketException {
        this.Block$();
        Ptr ptr = null;
        Ptr ptr2 = null;
        try {
            ptr2 = ptr = NetworkInterfaceImpl.detectInterfaces();
            while (ptr2 != null) {
                String string = NetworkInterfaceImpl.getName(ptr2);
                NetworkInterface networkInterface = (NetworkInterface)this.detectedInterfaces.get(string);
                if (networkInterface == null) {
                    networkInterface = new NetworkInterface(string, string);
                    this.detectedInterfaces.put(string, networkInterface);
                }
                try {
                    String string2 = NetworkInterfaceImpl.getIPAddress(ptr2);
                    if (string2 != null) {
                        InetAddress inetAddress = InetAddress.getByName(string2);
                        networkInterface.setPrimaryAddress(inetAddress);
                        this.addressToName.put(inetAddress, networkInterface.getName());
                        networkInterface.getInetAddressesInternal().addElement(inetAddress);
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                ptr2 = NetworkInterfaceImpl.getNext(ptr2);
            }
            this.detectedInterfaces.elements();
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            NetworkInterfaceImpl.freeInterfaces(ptr);
            throw throwable;
        }
        Object var4_8 = null;
        NetworkInterfaceImpl.freeInterfaces(ptr);
    }

    Hashtable getDetectedInterfaces() {
        return this.detectedInterfaces;
    }

    Hashtable getAddressToName() {
        return this.addressToName;
    }

    String nameForAddress(InetAddress inetAddress) {
        return (String)this.addressToName.get(inetAddress);
    }

    public String toString() {
        return new StringBuffer().append("NetworkInterfaceImpl[detectedInterfaces={ ").append(this.detectedInterfaces).append(" }; addressToName={ ").append(this.addressToName).append("]").toString();
    }

    static {
        System.loadLibrary("net");
    }

    private /* synthetic */ void Block$() {
        this.detectedInterfaces = new Hashtable();
        this.addressToName = new Hashtable();
    }
}

