/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import kaffe.lang.PackageHelper;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLClassLoader
extends SecureClassLoader {
    private final Vector urls;
    private final URLStreamHandlerFactory factory;
    private final Map handlers;
    private final Map jarFiles;

    public URLClassLoader(URL[] uRLArray, ClassLoader classLoader) {
        this(uRLArray, classLoader, null);
    }

    public URLClassLoader(URL[] uRLArray) {
        this(uRLArray, Class.forName("java.net.URLClassLoader").getClassLoader(), null);
    }

    public URLClassLoader(URL[] uRLArray, ClassLoader classLoader, URLStreamHandlerFactory uRLStreamHandlerFactory) {
        super(classLoader);
        this.Block$();
        this.urls = new Vector();
        this.factory = uRLStreamHandlerFactory;
        int n = 0;
        while (n < uRLArray.length) {
            this.internalAddURL(uRLArray[n]);
            ++n;
        }
    }

    protected void addURL(URL uRL) {
        this.internalAddURL(uRL);
    }

    private void internalAddURL(URL uRL) {
        this.urls.addElement(uRL);
    }

    public URL[] getURLs() {
        return (URL[])this.urls.toArray(new URL[this.urls.size()]);
    }

    @Override
    protected Class findClass(String string) throws ClassNotFoundException {
        URL uRL = this.findResourceInternal(null, new StringBuffer().append(string.replace('.', '/')).append(".class").toString());
        if (uRL == null) {
            throw new ClassNotFoundException(string);
        }
        try {
            Class clazz;
            String string2;
            int n;
            InputStream inputStream = uRL.openStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byArray = byteArrayOutputStream.toByteArray();
            URL uRL2 = uRL;
            if (uRL.getProtocol().equals("jar")) {
                uRL2 = new URL(uRL.getFile().substring(0, uRL.getFile().indexOf("!/")));
            }
            if (this.getPackage(string2 = PackageHelper.getPackageName(clazz = this.defineClass(string, byArray, 0, byArray.length, new CodeSource(uRL2, new Certificate[0])))) == null) {
                if (inputStream instanceof JarInputStream) {
                    this.definePackage(string2, ((JarInputStream)inputStream).getManifest(), uRL);
                } else {
                    this.definePackage(string2, null, null, null, null, null, null, null);
                }
            }
            inputStream.close();
            return clazz;
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(new StringBuffer().append(string).append(": ").append(iOException).toString());
        }
    }

    private URLStreamHandler getHandler(URL uRL) {
        if (this.factory == null) {
            return null;
        }
        String string = uRL.getProtocol();
        URLStreamHandler uRLStreamHandler = (URLStreamHandler)this.handlers.get(string);
        if (uRLStreamHandler == null) {
            uRLStreamHandler = this.factory.createURLStreamHandler(string);
            this.handlers.put(string, uRLStreamHandler);
        }
        return uRLStreamHandler;
    }

    protected Package definePackage(String string, Manifest manifest, URL uRL) throws IllegalArgumentException {
        Attributes attributes = manifest.getAttributes(string);
        if (attributes == null) {
            attributes = manifest.getMainAttributes();
        }
        return super.definePackage(string, attributes.getValue(Attributes.Name.SPECIFICATION_TITLE), attributes.getValue(Attributes.Name.SPECIFICATION_VERSION), attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR), attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE), attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION), attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR), null);
    }

    @Override
    public URL findResource(String string) {
        return this.findResourceInternal(null, string);
    }

    @Override
    public Enumeration findResources(String string) throws IOException {
        Vector vector = new Vector();
        this.findResourceInternal(vector, string);
        return vector.elements();
    }

    private URL findResourceInternal(Vector vector, String string) {
        if (string.charAt(0) == '/') {
            string = string.substring(1);
        }
        int n = 0;
        while (n < this.urls.size()) {
            block9: {
                URL uRL = (URL)this.urls.elementAt(n);
                try {
                    Object object;
                    if (uRL.getFile().endsWith("/")) {
                        uRL = new URL(uRL, string, this.getHandler(uRL));
                    } else {
                        object = this.getJar(uRL);
                        if (object == null) break block9;
                        uRL = new URL(new StringBuffer().append("jar:file:").append(object).append("!/").append(string).toString());
                    }
                    object = uRL.openConnection();
                    try {
                        object.getClass().getMethod("disconnect", null).invoke(object, new Object[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (vector != null) {
                        vector.addElement(uRL);
                        break block9;
                    }
                    return uRL;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ++n;
        }
        return null;
    }

    private File getJar(URL uRL) {
        File file = (File)this.jarFiles.get(uRL);
        if (file != null) {
            return file;
        }
        String string = uRL.getProtocol();
        String string2 = uRL.getHost();
        if ((string.equals("file") || string.equals("jar")) && (string2.equals("") || string2.equals("localhost")) && (file = new File(uRL.getFile())).exists() && !file.isDirectory()) {
            this.jarFiles.put(uRL, file);
            return file;
        }
        try {
            int n;
            file = File.createTempFile("jar", null);
            file.deleteOnExit();
            InputStream inputStream = uRL.openStream();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            inputStream.close();
            fileOutputStream.close();
            this.jarFiles.put(uRL, file);
            return file;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        return super.getPermissions(codeSource);
    }

    public static URLClassLoader newInstance(URL[] uRLArray, ClassLoader classLoader) {
        return new URLClassLoader(uRLArray, classLoader);
    }

    public static URLClassLoader newInstance(URL[] uRLArray) {
        return new URLClassLoader(uRLArray);
    }

    private /* synthetic */ void Block$() {
        this.handlers = new Hashtable();
        this.jarFiles = new Hashtable();
    }
}

