/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ByteBufferImpl;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ByteBuffer
extends Buffer
implements Comparable {
    private ByteOrder endian;
    int array_offset;
    byte[] backing_buffer;

    protected ByteBuffer(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.Block$();
        this.array_offset = 0;
    }

    ByteBuffer(byte[] byArray, int n, int n2, int n3, int n4, int n5) {
        super(n2, n3, n4, n5);
        this.Block$();
        this.backing_buffer = byArray;
        this.array_offset = n;
    }

    public static ByteBuffer allocateDirect(int n) {
        return ByteBuffer.allocate(n);
    }

    public static ByteBuffer allocate(int n) {
        return new ByteBufferImpl(n);
    }

    public static final ByteBuffer wrap(byte[] byArray, int n, int n2) {
        return new ByteBufferImpl(byArray, 0, byArray.length, n + n2, n, -1, false);
    }

    public static final ByteBuffer wrap(byte[] byArray) {
        return ByteBuffer.wrap(byArray, 0, byArray.length);
    }

    public ByteBuffer get(byte[] byArray, int n, int n2) {
        if (n < 0 || n > byArray.length || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n;
        while (n3 < n + n2) {
            byArray[n3] = this.get();
            ++n3;
        }
        return this;
    }

    public ByteBuffer get(byte[] byArray) {
        return this.get(byArray, 0, byArray.length);
    }

    public ByteBuffer put(ByteBuffer byteBuffer) {
        if (byteBuffer == this) {
            throw new IllegalArgumentException();
        }
        if (byteBuffer.remaining() > this.remaining()) {
            throw new BufferOverflowException();
        }
        if (byteBuffer.remaining() > 0) {
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            byteBuffer.put(byArray);
        }
        return this;
    }

    public ByteBuffer put(byte[] byArray, int n, int n2) {
        if (n < 0 || n > byArray.length || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n;
        while (n3 < n + n2) {
            this.put(byArray[n3]);
            ++n3;
        }
        return this;
    }

    public final ByteBuffer put(byte[] byArray) {
        return this.put(byArray, 0, byArray.length);
    }

    public final boolean hasArray() {
        return this.backing_buffer != null && !this.isReadOnly();
    }

    public final byte[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.array_offset;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof ByteBuffer) {
            return this.compareTo(object) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(Object object) {
        ByteBuffer byteBuffer = (ByteBuffer)object;
        if (byteBuffer.remaining() != this.remaining()) {
            return 1;
        }
        if (!this.hasArray() || !byteBuffer.hasArray()) {
            return 1;
        }
        int n = this.remaining();
        int n2 = this.position();
        int n3 = byteBuffer.position();
        int n4 = 0;
        while (n4 < n) {
            int n5 = this.get(n2) - byteBuffer.get(n3);
            if (n5 != 0) {
                return n5;
            }
            ++n4;
        }
        return 0;
    }

    public final ByteOrder order() {
        return this.endian;
    }

    public final ByteBuffer order(ByteOrder byteOrder) {
        this.endian = byteOrder;
        return this;
    }

    public abstract byte get();

    public abstract ByteBuffer put(byte var1);

    public abstract byte get(int var1);

    public abstract ByteBuffer put(int var1, byte var2);

    public abstract ByteBuffer compact();

    public abstract boolean isDirect();

    public abstract ByteBuffer slice();

    public abstract ByteBuffer duplicate();

    public abstract ByteBuffer asReadOnlyBuffer();

    public abstract ShortBuffer asShortBuffer();

    public abstract CharBuffer asCharBuffer();

    public abstract IntBuffer asIntBuffer();

    public abstract LongBuffer asLongBuffer();

    public abstract FloatBuffer asFloatBuffer();

    public abstract DoubleBuffer asDoubleBuffer();

    public abstract char getChar();

    public abstract ByteBuffer putChar(char var1);

    public abstract char getChar(int var1);

    public abstract ByteBuffer putChar(int var1, char var2);

    public abstract short getShort();

    public abstract ByteBuffer putShort(short var1);

    public abstract short getShort(int var1);

    public abstract ByteBuffer putShort(int var1, short var2);

    public abstract int getInt();

    public abstract ByteBuffer putInt(int var1);

    public abstract int getInt(int var1);

    public abstract ByteBuffer putInt(int var1, int var2);

    public abstract long getLong();

    public abstract ByteBuffer putLong(long var1);

    public abstract long getLong(int var1);

    public abstract ByteBuffer putLong(int var1, long var2);

    public abstract float getFloat();

    public abstract ByteBuffer putFloat(float var1);

    public abstract float getFloat(int var1);

    public abstract ByteBuffer putFloat(int var1, float var2);

    public abstract double getDouble();

    public abstract ByteBuffer putDouble(double var1);

    public abstract double getDouble(int var1);

    public abstract ByteBuffer putDouble(int var1, double var2);

    public String toString() {
        return new StringBuffer().append(this.getClass().getName()).append("[pos=").append(this.position()).append(" lim=").append(this.limit()).append(" cap=").append(this.capacity()).append("]").toString();
    }

    private /* synthetic */ void Block$() {
        this.endian = ByteOrder.BIG_ENDIAN;
    }
}

