/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ByteOrder;
import java.nio.CharBufferImpl;
import java.nio.ReadOnlyBufferException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CharBuffer
extends Buffer
implements Comparable,
CharSequence {
    int array_offset;
    char[] backing_buffer;

    protected CharBuffer(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.array_offset = 0;
    }

    CharBuffer(char[] cArray, int n, int n2, int n3, int n4, int n5) {
        super(n2, n3, n4, n5);
        this.backing_buffer = cArray;
        this.array_offset = n;
    }

    public static CharBuffer allocate(int n) {
        return new CharBufferImpl(n);
    }

    public static final CharBuffer wrap(char[] cArray, int n, int n2) {
        return new CharBufferImpl(cArray, 0, cArray.length, n + n2, n, -1, false);
    }

    public static final CharBuffer wrap(CharSequence charSequence) {
        return CharBuffer.wrap(charSequence, 0, charSequence.length());
    }

    public static final CharBuffer wrap(CharSequence charSequence, int n, int n2) {
        if (n < 0 || n > charSequence.length() || n2 < 0 || n2 > charSequence.length() - n) {
            throw new IndexOutOfBoundsException();
        }
        char[] cArray = new char[charSequence.length()];
        int n3 = n;
        while (n3 < n2) {
            cArray[n3] = charSequence.charAt(n3);
            ++n3;
        }
        return CharBuffer.wrap(cArray, n, n2).asReadOnlyBuffer();
    }

    public static final CharBuffer wrap(char[] cArray) {
        return CharBuffer.wrap(cArray, 0, cArray.length);
    }

    public CharBuffer get(char[] cArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            cArray[n3] = this.get();
            ++n3;
        }
        return this;
    }

    public CharBuffer get(char[] cArray) {
        return this.get(cArray, 0, cArray.length);
    }

    public CharBuffer put(CharBuffer charBuffer) {
        if (charBuffer == this) {
            throw new IllegalArgumentException();
        }
        if (charBuffer.remaining() > this.remaining()) {
            throw new BufferOverflowException();
        }
        if (charBuffer.remaining() > 0) {
            char[] cArray = new char[charBuffer.remaining()];
            charBuffer.get(cArray);
            charBuffer.put(cArray);
        }
        return this;
    }

    public CharBuffer put(char[] cArray, int n, int n2) {
        if (n < 0 || n >= cArray.length || n2 < 0 || n2 > cArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 > this.remaining()) {
            throw new BufferOverflowException();
        }
        int n3 = n;
        while (n3 < n + n2) {
            this.put(cArray[n3]);
            ++n3;
        }
        return this;
    }

    public final CharBuffer put(char[] cArray) {
        return this.put(cArray, 0, cArray.length);
    }

    public final boolean hasArray() {
        return this.backing_buffer != null && !this.isReadOnly();
    }

    public final char[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.array_offset;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof CharBuffer) {
            return this.compareTo(object) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(Object object) {
        CharBuffer charBuffer = (CharBuffer)object;
        if (charBuffer.remaining() != this.remaining()) {
            return 1;
        }
        if (!this.hasArray() || !charBuffer.hasArray()) {
            return 1;
        }
        int n = this.remaining();
        int n2 = this.position();
        int n3 = charBuffer.position();
        int n4 = 0;
        while (n4 < n) {
            int n5 = this.get(n2) - charBuffer.get(n3);
            if (n5 != 0) {
                return n5;
            }
            ++n4;
        }
        return 0;
    }

    public abstract ByteOrder order();

    public abstract char get();

    public abstract CharBuffer put(char var1);

    public abstract char get(int var1);

    public abstract CharBuffer put(int var1, char var2);

    public abstract CharBuffer compact();

    public abstract boolean isDirect();

    public abstract CharBuffer slice();

    public abstract CharBuffer duplicate();

    public abstract CharBuffer asReadOnlyBuffer();

    @Override
    public String toString() {
        if (this.hasArray()) {
            return new String(this.array(), this.position(), this.length());
        }
        char[] cArray = new char[this.length()];
        int n = this.position();
        this.get(cArray, 0, cArray.length);
        this.position(n);
        return new String(cArray);
    }

    @Override
    public final int length() {
        return this.remaining();
    }

    @Override
    public abstract CharSequence subSequence(int var1, int var2);

    public CharBuffer put(String string, int n, int n2) {
        return this.put(string.toCharArray(), n, n2);
    }

    public final CharBuffer put(String string) {
        return this.put(string.toCharArray(), 0, string.length());
    }

    @Override
    public final char charAt(int n) {
        if (n < 0 || n >= this.remaining()) {
            throw new IndexOutOfBoundsException();
        }
        return this.get(this.position() + n);
    }
}

