/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
class CharViewBufferImpl
extends CharBuffer {
    private boolean readOnly;
    private int offset;
    private ByteBuffer bb;
    private ByteOrder endian;

    public CharViewBufferImpl(ByteBuffer byteBuffer, boolean bl) {
        super(byteBuffer.remaining() >> 1, byteBuffer.remaining() >> 1, byteBuffer.position(), 0);
        this.bb = byteBuffer;
        this.readOnly = bl;
        this.endian = byteBuffer.order();
    }

    public CharViewBufferImpl(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5, boolean bl) {
        super(n3 >> 1, n3 >> 1, n4 >> 1, n5 >> 1);
        this.bb = byteBuffer;
        this.offset = n;
        this.readOnly = bl;
        this.endian = byteBuffer.order();
    }

    @Override
    public char get() {
        char c = this.bb.getChar((this.position() << 1) + this.offset);
        this.position(this.position() + 1);
        return c;
    }

    @Override
    public char get(int n) {
        return this.bb.getChar((n << 1) + this.offset);
    }

    @Override
    public CharBuffer put(char c) {
        this.bb.putChar((this.position() << 1) + this.offset, c);
        this.position(this.position() + 1);
        return this;
    }

    @Override
    public CharBuffer put(int n, char c) {
        this.bb.putChar((n << 1) + this.offset, c);
        return this;
    }

    @Override
    public CharBuffer compact() {
        if (this.position() > 0) {
            int n = this.limit() - this.position();
            int n2 = 0;
            while (n2 < n) {
                this.bb.putChar((n2 >> 1) + this.offset, this.bb.getChar((n2 + this.position() >> 1) + this.offset));
                ++n2;
            }
            this.position(n);
            this.limit(this.capacity());
        }
        return this;
    }

    @Override
    public CharBuffer duplicate() {
        return new CharViewBufferImpl(this.bb, this.offset, this.capacity(), this.limit(), this.position(), -1, this.isReadOnly());
    }

    @Override
    public CharBuffer slice() {
        return new CharViewBufferImpl(this.bb, (this.position() >> 1) + this.offset, this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        if (n < 0 || n > this.length() || n2 < n || n2 > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        return new CharViewBufferImpl(this.bb, this.array_offset, this.capacity(), this.position() + n2, this.position() + n, -1, this.isReadOnly());
    }

    @Override
    public CharBuffer asReadOnlyBuffer() {
        return new CharViewBufferImpl(this.bb, (this.position() >> 1) + this.offset, this.remaining(), this.remaining(), 0, -1, true);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isDirect() {
        return this.bb.isDirect();
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }
}

