/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import gnu.classpath.RawData;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.CharViewBufferImpl;
import java.nio.DoubleBuffer;
import java.nio.DoubleViewBufferImpl;
import java.nio.FloatBuffer;
import java.nio.FloatViewBufferImpl;
import java.nio.IntBuffer;
import java.nio.IntViewBufferImpl;
import java.nio.LongBuffer;
import java.nio.LongViewBufferImpl;
import java.nio.ShortBuffer;
import java.nio.ShortViewBufferImpl;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectByteBufferImpl
extends ByteBuffer {
    private RawData address;
    private int offset;
    private boolean readOnly;

    public DirectByteBufferImpl(RawData rawData, int n, int n2, int n3, int n4, int n5, boolean bl) {
        super(n2, n3, n4, n5);
        this.address = rawData;
        this.offset = n;
        this.readOnly = bl;
    }

    private static native RawData allocateImpl(int var0);

    private static native void freeImpl(RawData var0);

    protected void finalize() throws Throwable {
        DirectByteBufferImpl.freeImpl(this.address);
    }

    public static ByteBuffer allocateDirect(int n) {
        RawData rawData = DirectByteBufferImpl.allocateImpl(n);
        if (rawData == null) {
            throw new InternalError("Not enough memory to create direct buffer");
        }
        return new DirectByteBufferImpl(rawData, 0, n, n, 0, -1, false);
    }

    private native byte getImpl(int var1);

    private native void putImpl(int var1, byte var2);

    @Override
    public byte get() {
        byte by = this.getImpl(this.position() + this.offset);
        this.position(this.position() + 1);
        return by;
    }

    @Override
    public byte get(int n) {
        return this.getImpl(n);
    }

    @Override
    public ByteBuffer put(byte by) {
        this.putImpl(this.position(), by);
        this.position(this.position() + 1);
        return this;
    }

    @Override
    public ByteBuffer put(int n, byte by) {
        this.putImpl(n, by);
        return this;
    }

    @Override
    public ByteBuffer compact() {
        int n = 0;
        while (this.remaining() > 0) {
            this.put(n, this.get());
            ++n;
        }
        this.position(n);
        return this;
    }

    @Override
    public ByteBuffer duplicate() {
        return new DirectByteBufferImpl(this.address, this.offset, this.capacity(), this.limit(), this.position(), -1, this.isReadOnly());
    }

    @Override
    public ByteBuffer slice() {
        return new DirectByteBufferImpl(this.address, this.position() + this.offset, this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    @Override
    public ByteBuffer asReadOnlyBuffer() {
        return new DirectByteBufferImpl(this.address, this.offset, this.capacity(), this.limit(), this.position(), -1, true);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public CharBuffer asCharBuffer() {
        return new CharViewBufferImpl(this, this.position() + this.offset, this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    @Override
    public DoubleBuffer asDoubleBuffer() {
        return new DoubleViewBufferImpl(this, this.position() + this.offset, this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    @Override
    public FloatBuffer asFloatBuffer() {
        return new FloatViewBufferImpl(this, this.position() + this.offset, this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    @Override
    public IntBuffer asIntBuffer() {
        return new IntViewBufferImpl(this, this.position() + this.offset, this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    @Override
    public LongBuffer asLongBuffer() {
        return new LongViewBufferImpl(this, this.position() + this.offset, this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    @Override
    public ShortBuffer asShortBuffer() {
        return new ShortViewBufferImpl(this, this.position() + this.offset, this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    @Override
    public final char getChar() {
        return (char)(((this.get() & 0xFF) << 8) + (this.get() & 0xFF));
    }

    @Override
    public final ByteBuffer putChar(char c) {
        this.put((byte)((c & 0xFF00) >> 8));
        this.put((byte)(c & 0xFF));
        return this;
    }

    @Override
    public final char getChar(int n) {
        return (char)(((this.get(n) & 0xFF) << 8) + (this.get(n + 1) & 0xFF));
    }

    @Override
    public final ByteBuffer putChar(int n, char c) {
        this.put(n, (byte)((c & 0xFF00) >> 8));
        this.put(n + 1, (byte)(c & 0xFF));
        return this;
    }

    @Override
    public final short getShort() {
        return (short)(((this.get() & 0xFF) << 8) + (this.get() & 0xFF));
    }

    @Override
    public final ByteBuffer putShort(short s) {
        this.put((byte)((s & 0xFF00) >> 8));
        this.put((byte)(s & 0xFF));
        return this;
    }

    @Override
    public final short getShort(int n) {
        return (short)(((this.get(n) & 0xFF) << 8) + (this.get(n + 1) & 0xFF));
    }

    @Override
    public final ByteBuffer putShort(int n, short s) {
        this.put(n, (byte)((s & 0xFF00) >> 8));
        this.put(n + 1, (byte)(s & 0xFF));
        return this;
    }

    @Override
    public final int getInt() {
        return ((this.get() & 0xFF) << 24) + (this.get() & 0xFF) << 16 + (this.get() & 0xFF) << 8 + (this.get() & 0xFF);
    }

    @Override
    public final ByteBuffer putInt(int n) {
        this.put((byte)((n & 0xFF000000) >> 24));
        this.put((byte)((n & 0xFF0000) >> 16));
        this.put((byte)((n & 0xFF00) >> 8));
        this.put((byte)(n & 0xFF));
        return this;
    }

    @Override
    public final int getInt(int n) {
        return ((this.get(n) & 0xFF) << 24) + (this.get(n + 1) & 0xFF) << 16 + (this.get(n + 2) & 0xFF) << 8 + (this.get(n + 3) & 0xFF);
    }

    @Override
    public final ByteBuffer putInt(int n, int n2) {
        this.put(n, (byte)((n2 & 0xFF000000) >> 24));
        this.put(n + 1, (byte)((n2 & 0xFF0000) >> 16));
        this.put(n + 2, (byte)((n2 & 0xFF00) >> 8));
        this.put(n + 3, (byte)(n2 & 0xFF));
        return this;
    }

    @Override
    public final long getLong() {
        return ((this.get() & 0xFF) << 56) + (this.get() & 0xFF) << 48 + (this.get() & 0xFF) << 40 + (this.get() & 0xFF) << 32 + (this.get() & 0xFF) << 24 + (this.get() & 0xFF) << 16 + (this.get() & 0xFF) << 8 + (this.get() & 0xFF);
    }

    @Override
    public final ByteBuffer putLong(long l) {
        this.put((byte)((l & 0xFF00000000000000L) >> 56));
        this.put((byte)((l & 0xFF000000000000L) >> 48));
        this.put((byte)((l & 0xFF0000000000L) >> 40));
        this.put((byte)((l & 0xFF00000000L) >> 32));
        this.put((byte)((l & 0xFF000000L) >> 24));
        this.put((byte)((l & 0xFF0000L) >> 16));
        this.put((byte)((l & 0xFF00L) >> 8));
        this.put((byte)(l & 0xFFL));
        return this;
    }

    @Override
    public final long getLong(int n) {
        return ((this.get(n) & 0xFF) << 56) + (this.get(n + 1) & 0xFF) << 48 + (this.get(n + 2) & 0xFF) << 40 + (this.get(n + 3) & 0xFF) << 32 + (this.get(n + 4) & 0xFF) << 24 + (this.get(n + 5) & 0xFF) << 16 + (this.get(n + 6) & 0xFF) << 8 + (this.get(n + 7) & 0xFF);
    }

    @Override
    public final ByteBuffer putLong(int n, long l) {
        this.put(n, (byte)((l & 0xFF00000000000000L) >> 56));
        this.put(n + 1, (byte)((l & 0xFF000000000000L) >> 48));
        this.put(n + 2, (byte)((l & 0xFF0000000000L) >> 40));
        this.put(n + 3, (byte)((l & 0xFF00000000L) >> 32));
        this.put(n + 4, (byte)((l & 0xFF000000L) >> 24));
        this.put(n + 5, (byte)((l & 0xFF0000L) >> 16));
        this.put(n + 6, (byte)((l & 0xFF00L) >> 8));
        this.put(n + 7, (byte)(l & 0xFFL));
        return this;
    }

    @Override
    public final float getFloat() {
        return ((this.get() & 0xFF) << 24) + (this.get() & 0xFF) << 16 + (this.get() & 0xFF) << 8 + (this.get() & 0xFF);
    }

    @Override
    public final ByteBuffer putFloat(float f) {
        this.put((byte)(((int)f & 0xFF000000) >> 24));
        this.put((byte)(((int)f & 0xFF0000) >> 16));
        this.put((byte)(((int)f & 0xFF00) >> 8));
        this.put((byte)((int)f & 0xFF));
        return this;
    }

    @Override
    public final float getFloat(int n) {
        return ((this.get(n) & 0xFF) << 24) + (this.get(n + 1) & 0xFF) << 16 + (this.get(n + 2) & 0xFF) << 8 + (this.get(n + 3) & 0xFF);
    }

    @Override
    public final ByteBuffer putFloat(int n, float f) {
        this.put(n, (byte)(((int)f & 0xFF000000) >> 24));
        this.put(n + 1, (byte)(((int)f & 0xFF0000) >> 16));
        this.put(n + 2, (byte)(((int)f & 0xFF00) >> 8));
        this.put(n + 3, (byte)((int)f & 0xFF));
        return this;
    }

    @Override
    public final double getDouble() {
        return ((this.get() & 0xFF) << 56) + (this.get() & 0xFF) << 48 + (this.get() & 0xFF) << 40 + (this.get() & 0xFF) << 32 + (this.get() & 0xFF) << 24 + (this.get() & 0xFF) << 16 + (this.get() & 0xFF) << 8 + (this.get() & 0xFF);
    }

    @Override
    public final ByteBuffer putDouble(double d) {
        this.put((byte)(((long)d & 0xFF00000000000000L) >> 56));
        this.put((byte)(((long)d & 0xFF000000000000L) >> 48));
        this.put((byte)(((long)d & 0xFF0000000000L) >> 40));
        this.put((byte)(((long)d & 0xFF00000000L) >> 32));
        this.put((byte)(((long)d & 0xFF000000L) >> 24));
        this.put((byte)(((long)d & 0xFF0000L) >> 16));
        this.put((byte)(((long)d & 0xFF00L) >> 8));
        this.put((byte)((long)d & 0xFFL));
        return this;
    }

    @Override
    public final double getDouble(int n) {
        return ((this.get(n) & 0xFF) << 56) + (this.get(n + 1) & 0xFF) << 48 + (this.get(n + 2) & 0xFF) << 40 + (this.get(n + 3) & 0xFF) << 32 + (this.get(n + 4) & 0xFF) << 24 + (this.get(n + 5) & 0xFF) << 16 + (this.get(n + 6) & 0xFF) << 8 + (this.get(n + 7) & 0xFF);
    }

    @Override
    public final ByteBuffer putDouble(int n, double d) {
        this.put(n, (byte)(((long)d & 0xFF00000000000000L) >> 56));
        this.put(n + 1, (byte)(((long)d & 0xFF000000000000L) >> 48));
        this.put(n + 2, (byte)(((long)d & 0xFF0000000000L) >> 40));
        this.put(n + 3, (byte)(((long)d & 0xFF00000000L) >> 32));
        this.put(n + 4, (byte)(((long)d & 0xFF000000L) >> 24));
        this.put(n + 5, (byte)(((long)d & 0xFF0000L) >> 16));
        this.put(n + 6, (byte)(((long)d & 0xFF00L) >> 8));
        this.put(n + 7, (byte)((long)d & 0xFFL));
        return this;
    }
}

