/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ByteOrder;
import java.nio.DoubleBufferImpl;
import java.nio.ReadOnlyBufferException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DoubleBuffer
extends Buffer
implements Comparable {
    int array_offset;
    double[] backing_buffer;

    protected DoubleBuffer(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.array_offset = 0;
    }

    DoubleBuffer(double[] dArray, int n, int n2, int n3, int n4, int n5) {
        super(n2, n3, n4, n5);
        this.backing_buffer = dArray;
        this.array_offset = n;
    }

    public static DoubleBuffer allocate(int n) {
        return new DoubleBufferImpl(n);
    }

    public static final DoubleBuffer wrap(double[] dArray, int n, int n2) {
        return new DoubleBufferImpl(dArray, 0, dArray.length, n + n2, n, -1, false);
    }

    public static final DoubleBuffer wrap(double[] dArray) {
        return DoubleBuffer.wrap(dArray, 0, dArray.length);
    }

    public DoubleBuffer get(double[] dArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            dArray[n3] = this.get();
            ++n3;
        }
        return this;
    }

    public DoubleBuffer get(double[] dArray) {
        return this.get(dArray, 0, dArray.length);
    }

    public DoubleBuffer put(DoubleBuffer doubleBuffer) {
        if (doubleBuffer == this) {
            throw new IllegalArgumentException();
        }
        if (doubleBuffer.remaining() > this.remaining()) {
            throw new BufferOverflowException();
        }
        if (doubleBuffer.remaining() > 0) {
            double[] dArray = new double[doubleBuffer.remaining()];
            doubleBuffer.get(dArray);
            doubleBuffer.put(dArray);
        }
        return this;
    }

    public DoubleBuffer put(double[] dArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            this.put(dArray[n3]);
            ++n3;
        }
        return this;
    }

    public final DoubleBuffer put(double[] dArray) {
        return this.put(dArray, 0, dArray.length);
    }

    public final boolean hasArray() {
        return this.backing_buffer != null && !this.isReadOnly();
    }

    public final double[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.array_offset;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof DoubleBuffer) {
            return this.compareTo(object) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(Object object) {
        DoubleBuffer doubleBuffer = (DoubleBuffer)object;
        if (doubleBuffer.remaining() != this.remaining()) {
            return 1;
        }
        if (!this.hasArray() || !doubleBuffer.hasArray()) {
            return 1;
        }
        int n = this.remaining();
        int n2 = this.position();
        int n3 = doubleBuffer.position();
        int n4 = 0;
        while (n4 < n) {
            int n5 = (int)(this.get(n2) - doubleBuffer.get(n3));
            if (n5 != 0) {
                return n5;
            }
            ++n4;
        }
        return 0;
    }

    public abstract ByteOrder order();

    public abstract double get();

    public abstract DoubleBuffer put(double var1);

    public abstract double get(int var1);

    public abstract DoubleBuffer put(int var1, double var2);

    public abstract DoubleBuffer compact();

    public abstract boolean isDirect();

    public abstract DoubleBuffer slice();

    public abstract DoubleBuffer duplicate();

    public abstract DoubleBuffer asReadOnlyBuffer();
}

