/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.ReadOnlyBufferException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DoubleBufferImpl
extends DoubleBuffer {
    private boolean readOnly;

    DoubleBufferImpl(int n) {
        this(new double[n], 0, n, n, 0, -1, false);
    }

    DoubleBufferImpl(double[] dArray, int n, int n2, int n3, int n4, int n5, boolean bl) {
        super(dArray, n, n2, n3, n4, n5);
        this.readOnly = bl;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public DoubleBuffer slice() {
        return new DoubleBufferImpl(this.backing_buffer, this.array_offset + this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    @Override
    public DoubleBuffer duplicate() {
        return new DoubleBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, this.isReadOnly());
    }

    @Override
    public DoubleBuffer asReadOnlyBuffer() {
        return new DoubleBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, true);
    }

    @Override
    public DoubleBuffer compact() {
        int n = 0;
        while (this.remaining() > 0) {
            this.put(n, this.get());
            ++n;
        }
        this.position(n);
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public final double get() {
        double d = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return d;
    }

    @Override
    public final DoubleBuffer put(double d) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[this.position()] = d;
        this.position(this.position() + 1);
        return this;
    }

    @Override
    public final double get(int n) {
        return this.backing_buffer[n];
    }

    @Override
    public final DoubleBuffer put(int n, double d) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[n] = d;
        return this;
    }

    @Override
    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

