/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
class DoubleViewBufferImpl
extends DoubleBuffer {
    private boolean readOnly;
    private int offset;
    private ByteBuffer bb;
    private ByteOrder endian;

    public DoubleViewBufferImpl(ByteBuffer byteBuffer, boolean bl) {
        super(byteBuffer.remaining() >> 3, byteBuffer.remaining() >> 3, byteBuffer.position(), 0);
        this.bb = byteBuffer;
        this.readOnly = bl;
        this.endian = byteBuffer.order();
    }

    public DoubleViewBufferImpl(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5, boolean bl) {
        super(n3 >> 3, n3 >> 3, n4 >> 3, n5 >> 3);
        this.bb = byteBuffer;
        this.offset = n;
        this.readOnly = bl;
        this.endian = byteBuffer.order();
    }

    @Override
    public double get() {
        double d = this.bb.getDouble((this.position() << 3) + this.offset);
        this.position(this.position() + 1);
        return d;
    }

    @Override
    public double get(int n) {
        return this.bb.getDouble((n << 3) + this.offset);
    }

    @Override
    public DoubleBuffer put(double d) {
        this.bb.putDouble((this.position() << 3) + this.offset, d);
        this.position(this.position() + 1);
        return this;
    }

    @Override
    public DoubleBuffer put(int n, double d) {
        this.bb.putDouble((n << 3) + this.offset, d);
        return this;
    }

    @Override
    public DoubleBuffer compact() {
        if (this.position() > 0) {
            int n = this.limit() - this.position();
            int n2 = 0;
            while (n2 < n) {
                this.bb.putDouble((n2 >> 3) + this.offset, this.bb.getDouble((n2 + this.position() >> 3) + this.offset));
                ++n2;
            }
            this.position(n);
            this.limit(this.capacity());
        }
        return this;
    }

    @Override
    public DoubleBuffer duplicate() {
        return new DoubleViewBufferImpl(this.bb, this.offset, this.capacity(), this.limit(), this.position(), -1, this.isReadOnly());
    }

    @Override
    public DoubleBuffer slice() {
        return new DoubleViewBufferImpl(this.bb, (this.position() >> 3) + this.offset, this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    @Override
    public DoubleBuffer asReadOnlyBuffer() {
        return new DoubleViewBufferImpl(this.bb, (this.position() >> 3) + this.offset, this.remaining(), this.remaining(), 0, -1, true);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isDirect() {
        return this.bb.isDirect();
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }
}

