/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ReadOnlyBufferException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FloatBufferImpl
extends FloatBuffer {
    private boolean readOnly;

    FloatBufferImpl(int n) {
        this(new float[n], 0, n, n, 0, -1, false);
    }

    FloatBufferImpl(float[] fArray, int n, int n2, int n3, int n4, int n5, boolean bl) {
        super(fArray, n, n2, n3, n4, n5);
        this.readOnly = bl;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public FloatBuffer slice() {
        return new FloatBufferImpl(this.backing_buffer, this.array_offset + this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    @Override
    public FloatBuffer duplicate() {
        return new FloatBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, this.isReadOnly());
    }

    @Override
    public FloatBuffer asReadOnlyBuffer() {
        return new FloatBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, true);
    }

    @Override
    public FloatBuffer compact() {
        int n = 0;
        while (this.remaining() > 0) {
            this.put(n, this.get());
            ++n;
        }
        this.position(n);
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public final float get() {
        float f = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return f;
    }

    @Override
    public final FloatBuffer put(float f) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[this.position()] = f;
        this.position(this.position() + 1);
        return this;
    }

    @Override
    public final float get(int n) {
        return this.backing_buffer[n];
    }

    @Override
    public final FloatBuffer put(int n, float f) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[n] = f;
        return this;
    }

    @Override
    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

