/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
class FloatViewBufferImpl
extends FloatBuffer {
    private boolean readOnly;
    private int offset;
    private ByteBuffer bb;
    private ByteOrder endian;

    public FloatViewBufferImpl(ByteBuffer byteBuffer, boolean bl) {
        super(byteBuffer.remaining() >> 2, byteBuffer.remaining() >> 2, byteBuffer.position(), 0);
        this.bb = byteBuffer;
        this.readOnly = bl;
        this.endian = byteBuffer.order();
    }

    public FloatViewBufferImpl(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5, boolean bl) {
        super(n3 >> 2, n3 >> 2, n4 >> 2, n5 >> 2);
        this.bb = byteBuffer;
        this.offset = n;
        this.readOnly = bl;
        this.endian = byteBuffer.order();
    }

    @Override
    public float get() {
        float f = this.bb.getFloat((this.position() << 2) + this.offset);
        this.position(this.position() + 1);
        return f;
    }

    @Override
    public float get(int n) {
        return this.bb.getFloat((n << 2) + this.offset);
    }

    @Override
    public FloatBuffer put(float f) {
        this.bb.putFloat((this.position() << 2) + this.offset, f);
        this.position(this.position() + 1);
        return this;
    }

    @Override
    public FloatBuffer put(int n, float f) {
        this.bb.putFloat((n << 2) + this.offset, f);
        return this;
    }

    @Override
    public FloatBuffer compact() {
        if (this.position() > 0) {
            int n = this.limit() - this.position();
            int n2 = 0;
            while (n2 < n) {
                this.bb.putFloat((n2 >> 2) + this.offset, this.bb.getFloat((n2 + this.position() >> 2) + this.offset));
                ++n2;
            }
            this.position(n);
            this.limit(this.capacity());
        }
        return this;
    }

    @Override
    public FloatBuffer duplicate() {
        return new FloatViewBufferImpl(this.bb, this.offset, this.capacity(), this.limit(), this.position(), -1, this.isReadOnly());
    }

    @Override
    public FloatBuffer slice() {
        return new FloatViewBufferImpl(this.bb, (this.position() >> 2) + this.offset, this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    @Override
    public FloatBuffer asReadOnlyBuffer() {
        return new FloatViewBufferImpl(this.bb, (this.position() >> 2) + this.offset, this.remaining(), this.remaining(), 0, -1, true);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isDirect() {
        return this.bb.isDirect();
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }
}

