/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ByteOrder;
import java.nio.IntBufferImpl;
import java.nio.ReadOnlyBufferException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IntBuffer
extends Buffer
implements Comparable {
    int array_offset;
    int[] backing_buffer;

    protected IntBuffer(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.array_offset = 0;
    }

    IntBuffer(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        super(n2, n3, n4, n5);
        this.backing_buffer = nArray;
        this.array_offset = n;
    }

    public static IntBuffer allocate(int n) {
        return new IntBufferImpl(n);
    }

    public static final IntBuffer wrap(int[] nArray, int n, int n2) {
        return new IntBufferImpl(nArray, 0, nArray.length, n + n2, n, -1, false);
    }

    public static final IntBuffer wrap(int[] nArray) {
        return IntBuffer.wrap(nArray, 0, nArray.length);
    }

    public IntBuffer get(int[] nArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            nArray[n3] = this.get();
            ++n3;
        }
        return this;
    }

    public IntBuffer get(int[] nArray) {
        return this.get(nArray, 0, nArray.length);
    }

    public IntBuffer put(IntBuffer intBuffer) {
        if (intBuffer == this) {
            throw new IllegalArgumentException();
        }
        if (intBuffer.remaining() > this.remaining()) {
            throw new BufferOverflowException();
        }
        if (intBuffer.remaining() > 0) {
            int[] nArray = new int[intBuffer.remaining()];
            intBuffer.get(nArray);
            intBuffer.put(nArray);
        }
        return this;
    }

    public IntBuffer put(int[] nArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            this.put(nArray[n3]);
            ++n3;
        }
        return this;
    }

    public final IntBuffer put(int[] nArray) {
        return this.put(nArray, 0, nArray.length);
    }

    public final boolean hasArray() {
        return this.backing_buffer != null && !this.isReadOnly();
    }

    public final int[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.array_offset;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof IntBuffer) {
            return this.compareTo(object) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(Object object) {
        IntBuffer intBuffer = (IntBuffer)object;
        if (intBuffer.remaining() != this.remaining()) {
            return 1;
        }
        if (!this.hasArray() || !intBuffer.hasArray()) {
            return 1;
        }
        int n = this.remaining();
        int n2 = this.position();
        int n3 = intBuffer.position();
        int n4 = 0;
        while (n4 < n) {
            int n5 = this.get(n2) - intBuffer.get(n3);
            if (n5 != 0) {
                return n5;
            }
            ++n4;
        }
        return 0;
    }

    public abstract ByteOrder order();

    public abstract int get();

    public abstract IntBuffer put(int var1);

    public abstract int get(int var1);

    public abstract IntBuffer put(int var1, int var2);

    public abstract IntBuffer compact();

    public abstract boolean isDirect();

    public abstract IntBuffer slice();

    public abstract IntBuffer duplicate();

    public abstract IntBuffer asReadOnlyBuffer();
}

