/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ReadOnlyBufferException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntBufferImpl
extends IntBuffer {
    private boolean readOnly;

    IntBufferImpl(int n) {
        this(new int[n], 0, n, n, 0, -1, false);
    }

    IntBufferImpl(int[] nArray, int n, int n2, int n3, int n4, int n5, boolean bl) {
        super(nArray, n, n2, n3, n4, n5);
        this.readOnly = bl;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public IntBuffer slice() {
        return new IntBufferImpl(this.backing_buffer, this.array_offset + this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    @Override
    public IntBuffer duplicate() {
        return new IntBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, this.isReadOnly());
    }

    @Override
    public IntBuffer asReadOnlyBuffer() {
        return new IntBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, true);
    }

    @Override
    public IntBuffer compact() {
        int n = 0;
        while (this.remaining() > 0) {
            this.put(n, this.get());
            ++n;
        }
        this.position(n);
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public final int get() {
        int n = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return n;
    }

    @Override
    public final IntBuffer put(int n) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[this.position()] = n;
        this.position(this.position() + 1);
        return this;
    }

    @Override
    public final int get(int n) {
        return this.backing_buffer[n];
    }

    @Override
    public final IntBuffer put(int n, int n2) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[n] = n2;
        return this;
    }

    @Override
    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

