/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
class IntViewBufferImpl
extends IntBuffer {
    private boolean readOnly;
    private int offset;
    private ByteBuffer bb;
    private ByteOrder endian;

    public IntViewBufferImpl(ByteBuffer byteBuffer, boolean bl) {
        super(byteBuffer.remaining() >> 2, byteBuffer.remaining() >> 2, byteBuffer.position(), 0);
        this.bb = byteBuffer;
        this.readOnly = bl;
        this.endian = byteBuffer.order();
    }

    public IntViewBufferImpl(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5, boolean bl) {
        super(n3 >> 2, n3 >> 2, n4 >> 2, n5 >> 2);
        this.bb = byteBuffer;
        this.offset = n;
        this.readOnly = bl;
        this.endian = byteBuffer.order();
    }

    @Override
    public int get() {
        int n = this.bb.getInt((this.position() << 2) + this.offset);
        this.position(this.position() + 1);
        return n;
    }

    @Override
    public int get(int n) {
        return this.bb.getInt((n << 2) + this.offset);
    }

    @Override
    public IntBuffer put(int n) {
        this.bb.putInt((this.position() << 2) + this.offset, n);
        this.position(this.position() + 1);
        return this;
    }

    @Override
    public IntBuffer put(int n, int n2) {
        this.bb.putInt((n << 2) + this.offset, n2);
        return this;
    }

    @Override
    public IntBuffer compact() {
        if (this.position() > 0) {
            int n = this.limit() - this.position();
            int n2 = 0;
            while (n2 < n) {
                this.bb.putInt((n2 >> 2) + this.offset, this.bb.getInt((n2 + this.position() >> 2) + this.offset));
                ++n2;
            }
            this.position(n);
            this.limit(this.capacity());
        }
        return this;
    }

    @Override
    public IntBuffer duplicate() {
        return new IntViewBufferImpl(this.bb, this.offset, this.capacity(), this.limit(), this.position(), -1, this.isReadOnly());
    }

    @Override
    public IntBuffer slice() {
        return new IntViewBufferImpl(this.bb, (this.position() >> 2) + this.offset, this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    @Override
    public IntBuffer asReadOnlyBuffer() {
        return new IntViewBufferImpl(this.bb, (this.position() >> 2) + this.offset, this.remaining(), this.remaining(), 0, -1, true);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isDirect() {
        return this.bb.isDirect();
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }
}

