/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
class LongViewBufferImpl
extends LongBuffer {
    private boolean readOnly;
    private int offset;
    private ByteBuffer bb;
    private ByteOrder endian;

    public LongViewBufferImpl(ByteBuffer byteBuffer, boolean bl) {
        super(byteBuffer.remaining() >> 3, byteBuffer.remaining() >> 3, byteBuffer.position(), 0);
        this.bb = byteBuffer;
        this.readOnly = bl;
        this.endian = byteBuffer.order();
    }

    public LongViewBufferImpl(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5, boolean bl) {
        super(n3 >> 3, n3 >> 3, n4 >> 3, n5 >> 3);
        this.bb = byteBuffer;
        this.offset = n;
        this.readOnly = bl;
        this.endian = byteBuffer.order();
    }

    @Override
    public long get() {
        long l = this.bb.getLong((this.position() << 3) + this.offset);
        this.position(this.position() + 1);
        return l;
    }

    @Override
    public long get(int n) {
        return this.bb.getLong((n << 3) + this.offset);
    }

    @Override
    public LongBuffer put(long l) {
        this.bb.putLong((this.position() << 3) + this.offset, l);
        this.position(this.position() + 1);
        return this;
    }

    @Override
    public LongBuffer put(int n, long l) {
        this.bb.putLong((n << 3) + this.offset, l);
        return this;
    }

    @Override
    public LongBuffer compact() {
        if (this.position() > 0) {
            int n = this.limit() - this.position();
            int n2 = 0;
            while (n2 < n) {
                this.bb.putLong((n2 >> 3) + this.offset, this.bb.getLong((n2 + this.position() >> 3) + this.offset));
                ++n2;
            }
            this.position(n);
            this.limit(this.capacity());
        }
        return this;
    }

    @Override
    public LongBuffer duplicate() {
        return new LongViewBufferImpl(this.bb, this.offset, this.capacity(), this.limit(), this.position(), -1, this.isReadOnly());
    }

    @Override
    public LongBuffer slice() {
        return new LongViewBufferImpl(this.bb, (this.position() >> 3) + this.offset, this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    @Override
    public LongBuffer asReadOnlyBuffer() {
        return new LongViewBufferImpl(this.bb, (this.position() >> 3) + this.offset, this.remaining(), this.remaining(), 0, -1, true);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isDirect() {
        return this.bb.isDirect();
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }
}

