/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBufferImpl;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ShortBuffer
extends Buffer
implements Comparable {
    int array_offset;
    short[] backing_buffer;

    protected ShortBuffer(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.array_offset = 0;
    }

    ShortBuffer(short[] sArray, int n, int n2, int n3, int n4, int n5) {
        super(n2, n3, n4, n5);
        this.backing_buffer = sArray;
        this.array_offset = n;
    }

    public static ShortBuffer allocate(int n) {
        return new ShortBufferImpl(n);
    }

    public static final ShortBuffer wrap(short[] sArray, int n, int n2) {
        return new ShortBufferImpl(sArray, 0, sArray.length, n + n2, n, -1, false);
    }

    public static final ShortBuffer wrap(short[] sArray) {
        return ShortBuffer.wrap(sArray, 0, sArray.length);
    }

    public ShortBuffer get(short[] sArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            sArray[n3] = this.get();
            ++n3;
        }
        return this;
    }

    public ShortBuffer get(short[] sArray) {
        return this.get(sArray, 0, sArray.length);
    }

    public ShortBuffer put(ShortBuffer shortBuffer) {
        if (shortBuffer == this) {
            throw new IllegalArgumentException();
        }
        if (shortBuffer.remaining() > this.remaining()) {
            throw new BufferOverflowException();
        }
        if (shortBuffer.remaining() > 0) {
            short[] sArray = new short[shortBuffer.remaining()];
            shortBuffer.get(sArray);
            shortBuffer.put(sArray);
        }
        return this;
    }

    public ShortBuffer put(short[] sArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            this.put(sArray[n3]);
            ++n3;
        }
        return this;
    }

    public final ShortBuffer put(short[] sArray) {
        return this.put(sArray, 0, sArray.length);
    }

    public final boolean hasArray() {
        return this.backing_buffer != null && !this.isReadOnly();
    }

    public final short[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.array_offset;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof ShortBuffer) {
            return this.compareTo(object) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(Object object) {
        ShortBuffer shortBuffer = (ShortBuffer)object;
        if (shortBuffer.remaining() != this.remaining()) {
            return 1;
        }
        if (!this.hasArray() || !shortBuffer.hasArray()) {
            return 1;
        }
        int n = this.remaining();
        int n2 = this.position();
        int n3 = shortBuffer.position();
        int n4 = 0;
        while (n4 < n) {
            int n5 = this.get(n2) - shortBuffer.get(n3);
            if (n5 != 0) {
                return n5;
            }
            ++n4;
        }
        return 0;
    }

    public abstract ByteOrder order();

    public abstract short get();

    public abstract ShortBuffer put(short var1);

    public abstract short get(int var1);

    public abstract ShortBuffer put(int var1, short var2);

    public abstract ShortBuffer compact();

    public abstract boolean isDirect();

    public abstract ShortBuffer slice();

    public abstract ShortBuffer duplicate();

    public abstract ShortBuffer asReadOnlyBuffer();
}

