/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ShortBufferImpl
extends ShortBuffer {
    private boolean readOnly;

    ShortBufferImpl(int n) {
        this(new short[n], 0, n, n, 0, -1, false);
    }

    ShortBufferImpl(short[] sArray, int n, int n2, int n3, int n4, int n5, boolean bl) {
        super(sArray, n, n2, n3, n4, n5);
        this.readOnly = bl;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public ShortBuffer slice() {
        return new ShortBufferImpl(this.backing_buffer, this.array_offset + this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    @Override
    public ShortBuffer duplicate() {
        return new ShortBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, this.isReadOnly());
    }

    @Override
    public ShortBuffer asReadOnlyBuffer() {
        return new ShortBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, true);
    }

    @Override
    public ShortBuffer compact() {
        int n = 0;
        while (this.remaining() > 0) {
            this.put(n, this.get());
            ++n;
        }
        this.position(n);
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public final short get() {
        short s = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return s;
    }

    @Override
    public final ShortBuffer put(short s) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[this.position()] = s;
        this.position(this.position() + 1);
        return this;
    }

    @Override
    public final short get(int n) {
        return this.backing_buffer[n];
    }

    @Override
    public final ShortBuffer put(int n, short s) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[n] = s;
        return this;
    }

    @Override
    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

