/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels;

import java.io.IOException;
import java.nio.channels.FileChannel;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileLock {
    FileChannel channel;
    long position;
    long size;
    boolean shared;

    protected FileLock(FileChannel fileChannel, long l, long l2, boolean bl) {
        if (l < 0L || l2 < 0L) {
            throw new IllegalArgumentException();
        }
        this.channel = fileChannel;
        this.position = l;
        this.size = l2;
        this.shared = bl;
    }

    public abstract boolean isValid();

    public abstract void release() throws IOException;

    public final FileChannel channel() {
        return this.channel;
    }

    public final boolean isShared() {
        return this.shared;
    }

    public final boolean overlaps(long l, long l2) {
        if (l > this.position + this.size) {
            return false;
        }
        return l + l2 >= this.position;
    }

    public final long position() {
        return this.position;
    }

    public final long size() {
        return this.size;
    }

    public final String toString() {
        return new StringBuffer().append("file-lock:pos=").append(this.position).append("size=").append(this.size).toString();
    }
}

