/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import gnu.java.nio.charset.Provider;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.charset.spi.CharsetProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Charset
implements Comparable {
    private static CharsetEncoder cachedEncoder;
    private static CharsetDecoder cachedDecoder;
    private final String canonicalName;
    private final String[] aliases;

    protected Charset(String string, String[] stringArray) {
        Charset.checkName(string);
        if (stringArray != null) {
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                Charset.checkName(stringArray[n2]);
                ++n2;
            }
        }
        this.canonicalName = string;
        this.aliases = stringArray;
    }

    private static void checkName(String string) {
        int n = string.length();
        if (n == 0) {
            throw new IllegalCharsetNameException(string);
        }
        char c = string.charAt(0);
        if (!('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9')) {
            throw new IllegalCharsetNameException(string);
        }
        int n2 = 1;
        while (n2 < n) {
            c = string.charAt(n2);
            if (!('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9' || c == '-' || c == '.' || c == ':' || c == '_')) {
                throw new IllegalCharsetNameException(string);
            }
            ++n2;
        }
    }

    public static boolean isSupported(String string) {
        return Charset.charsetForName(string) != null;
    }

    public static Charset forName(String string) {
        Charset charset = Charset.charsetForName(string);
        if (charset == null) {
            throw new UnsupportedCharsetException(string);
        }
        return charset;
    }

    private static Charset charsetForName(String string) {
        Charset.checkName(string);
        return Charset.provider().charsetForName(string);
    }

    public static SortedMap availableCharsets() {
        TreeMap treeMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        Iterator iterator = Charset.provider().charsets();
        while (iterator.hasNext()) {
            Charset charset = (Charset)iterator.next();
            treeMap.put(charset.name(), charset);
        }
        return Collections.unmodifiableSortedMap(treeMap);
    }

    private static final CharsetProvider provider() {
        return Provider.provider();
    }

    public final String name() {
        return this.canonicalName;
    }

    public final Set aliases() {
        if (this.aliases == null) {
            return Collections.EMPTY_SET;
        }
        int n = this.aliases.length;
        HashSet hashSet = new HashSet(n);
        int n2 = 0;
        while (n2 < n) {
            hashSet.add(this.aliases[n2]);
            ++n2;
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public String displayName() {
        return this.canonicalName;
    }

    public String displayName(Locale locale2) {
        return this.canonicalName;
    }

    public final boolean isRegistered() {
        return !this.canonicalName.startsWith("x-") && !this.canonicalName.startsWith("X-");
    }

    public abstract boolean contains(Charset var1);

    public abstract CharsetDecoder newDecoder();

    public abstract CharsetEncoder newEncoder();

    public boolean canEncode() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ByteBuffer encode(CharBuffer charBuffer) {
        try {
            Class clazz = Class.forName("java.nio.charset.Charset");
            synchronized (clazz) {
                if (cachedEncoder == null) {
                    cachedEncoder = this.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
                }
                return cachedEncoder.encode(charBuffer);
            }
        }
        catch (CharacterCodingException characterCodingException) {
            throw new AssertionError((Object)characterCodingException);
        }
    }

    public final ByteBuffer encode(String string) {
        return this.encode(CharBuffer.wrap(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharBuffer decode(ByteBuffer byteBuffer) {
        try {
            Class clazz = Class.forName("java.nio.charset.Charset");
            synchronized (clazz) {
                if (cachedDecoder == null) {
                    cachedDecoder = this.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
                }
                return cachedDecoder.decode(byteBuffer);
            }
        }
        catch (CharacterCodingException characterCodingException) {
            throw new AssertionError((Object)characterCodingException);
        }
    }

    @Override
    public final int compareTo(Object object) {
        return this.canonicalName.compareToIgnoreCase(((Charset)object).canonicalName);
    }

    public final int hashCode() {
        return this.canonicalName.hashCode();
    }

    public final boolean equals(Object object) {
        if (object instanceof Charset) {
            return this.canonicalName.equalsIgnoreCase(((Charset)object).canonicalName);
        }
        return false;
    }

    public final String toString() {
        return this.canonicalName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class clazz = Class.forName("java.nio.charset.Charset");
        synchronized (clazz) {
            cachedEncoder = null;
            cachedDecoder = null;
            return;
        }
    }
}

