/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CoderMalfunctionError;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CharsetDecoder {
    private static final int STATE_RESET = 0;
    private static final int STATE_CODING = 1;
    private static final int STATE_END = 2;
    private static final int STATE_FLUSHED = 3;
    private static final String DEFAULT_REPLACEMENT = "\ufffd";
    private final Charset charset;
    private final float averageCharsPerByte;
    private final float maxCharsPerByte;
    private String replacement;
    private int state;
    private CodingErrorAction malformedInputAction;
    private CodingErrorAction unmappableCharacterAction;

    private CharsetDecoder(Charset charset, float f, float f2, String string) {
        this.Block$();
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Non-positive averageCharsPerByte");
        }
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException("Non-positive maxCharsPerByte");
        }
        this.charset = charset;
        this.averageCharsPerByte = f;
        this.maxCharsPerByte = f2;
        this.replacement = string;
        this.implReplaceWith(string);
    }

    protected CharsetDecoder(Charset charset, float f, float f2) {
        this(charset, f, f2, DEFAULT_REPLACEMENT);
    }

    public final float averageCharsPerByte() {
        return this.averageCharsPerByte;
    }

    public final Charset charset() {
        return this.charset;
    }

    public final CharBuffer decode(ByteBuffer byteBuffer) throws CharacterCodingException {
        if (this.state != 0) {
            throw new IllegalStateException();
        }
        int n = byteBuffer.remaining();
        int n2 = (int)((float)n * this.maxCharsPerByte());
        CharBuffer charBuffer = CharBuffer.allocate(n2);
        if (n == 0) {
            this.state = 3;
            return charBuffer;
        }
        CoderResult coderResult = this.decode(byteBuffer, charBuffer, true);
        if (coderResult.isError()) {
            coderResult.throwException();
        }
        if ((coderResult = this.flush(charBuffer)).isError()) {
            coderResult.throwException();
        }
        charBuffer.flip();
        return charBuffer;
    }

    public final CoderResult decode(ByteBuffer byteBuffer, CharBuffer charBuffer, boolean bl) {
        int n;
        int n2 = n = bl ? 2 : 1;
        if (!(this.state == 0 || this.state == 1 || bl && this.state == 2)) {
            throw new IllegalStateException();
        }
        this.state = n;
        while (true) {
            CodingErrorAction codingErrorAction;
            CoderResult coderResult;
            try {
                coderResult = this.decodeLoop(byteBuffer, charBuffer);
            }
            catch (RuntimeException runtimeException) {
                throw new CoderMalfunctionError(runtimeException);
            }
            if (coderResult.isOverflow()) {
                return coderResult;
            }
            if (coderResult.isUnderflow()) {
                if (bl && byteBuffer.hasRemaining()) {
                    coderResult = CoderResult.malformedForLength(byteBuffer.remaining());
                } else {
                    return coderResult;
                }
            }
            CodingErrorAction codingErrorAction2 = codingErrorAction = coderResult.isMalformed() ? this.malformedInputAction : this.unmappableCharacterAction;
            if (codingErrorAction == CodingErrorAction.REPORT) {
                return coderResult;
            }
            if (codingErrorAction == CodingErrorAction.REPLACE) {
                if (charBuffer.remaining() < this.replacement.length()) {
                    return CoderResult.OVERFLOW;
                }
                charBuffer.put(this.replacement);
            }
            byteBuffer.position(byteBuffer.position() + coderResult.length());
        }
    }

    protected abstract CoderResult decodeLoop(ByteBuffer var1, CharBuffer var2);

    public Charset detectedCharset() {
        throw new UnsupportedOperationException();
    }

    public final CoderResult flush(CharBuffer charBuffer) {
        if (this.state != 0 && this.state != 2) {
            throw new IllegalStateException();
        }
        this.state = 3;
        return this.implFlush(charBuffer);
    }

    protected CoderResult implFlush(CharBuffer charBuffer) {
        return CoderResult.UNDERFLOW;
    }

    public final CharsetDecoder onMalformedInput(CodingErrorAction codingErrorAction) {
        if (codingErrorAction == null) {
            throw new IllegalArgumentException("Null action");
        }
        this.malformedInputAction = codingErrorAction;
        this.implOnMalformedInput(codingErrorAction);
        return this;
    }

    protected void implOnMalformedInput(CodingErrorAction codingErrorAction) {
    }

    protected void implOnUnmappableCharacter(CodingErrorAction codingErrorAction) {
    }

    protected void implReplaceWith(String string) {
    }

    protected void implReset() {
    }

    public boolean isAutoDetecting() {
        return false;
    }

    public boolean isCharsetDetected() {
        throw new UnsupportedOperationException();
    }

    public CodingErrorAction malformedInputAction() {
        return this.malformedInputAction;
    }

    public final float maxCharsPerByte() {
        return this.maxCharsPerByte;
    }

    public final CharsetDecoder onUnmappableCharacter(CodingErrorAction codingErrorAction) {
        if (codingErrorAction == null) {
            throw new IllegalArgumentException("Null action");
        }
        this.unmappableCharacterAction = codingErrorAction;
        this.implOnUnmappableCharacter(codingErrorAction);
        return this;
    }

    public final String replacement() {
        return this.replacement;
    }

    public final CharsetDecoder replaceWith(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null replacement");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Empty replacement");
        }
        this.replacement = string;
        this.implReplaceWith(string);
        return this;
    }

    public final CharsetDecoder reset() {
        this.state = 0;
        this.implReset();
        return this;
    }

    public CodingErrorAction unmappableCharacterAction() {
        return this.unmappableCharacterAction;
    }

    private /* synthetic */ void Block$() {
        this.state = 0;
        this.malformedInputAction = CodingErrorAction.REPORT;
        this.unmappableCharacterAction = CodingErrorAction.REPORT;
    }
}

