/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.dgc;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.UID;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VMID
implements Serializable {
    private static final long serialVersionUID = -538642295484486218L;
    private static final boolean areWeUnique;
    private static byte[] localAddr;
    private byte[] addr = localAddr;
    private UID uid = new UID();

    public static boolean isUnique() {
        return areWeUnique;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof VMID)) {
            return false;
        }
        VMID vMID = (VMID)object;
        if (this.addr.length != vMID.addr.length) {
            return false;
        }
        int n = this.addr.length - 1;
        while (n >= 0) {
            if (this.addr[n] != vMID.addr[n]) {
                return false;
            }
            --n;
        }
        return this.uid.equals(vMID.uid);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[VMID: ");
        int n = 0;
        while (n < this.addr.length) {
            if (n > 0) {
                stringBuffer.append(".");
            }
            stringBuffer.append(Integer.toString(this.addr[n]));
            ++n;
        }
        stringBuffer.append(" ");
        stringBuffer.append(this.uid.toString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    static {
        byte[] byArray;
        boolean bl = true;
        try {
            byArray = InetAddress.getLocalHost().getAddress();
            if (byArray[0] == 127 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 1) {
                bl = false;
            }
        }
        catch (UnknownHostException unknownHostException) {
            byArray = new byte[]{127, 0, 0, 1};
            bl = false;
        }
        localAddr = byArray;
        areWeUnique = bl;
    }
}

