/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlgorithmParameters {
    private static final String ENGINE_CLASS = "AlgorithmParameters";
    private AlgorithmParametersSpi paramSpi;
    private Provider provider;
    private String algorithm;

    protected AlgorithmParameters(AlgorithmParametersSpi algorithmParametersSpi, Provider provider, String string) {
        this.paramSpi = algorithmParametersSpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        this.paramSpi.engineInit(algorithmParameterSpec);
    }

    public final void init(byte[] byArray) throws IOException {
        this.paramSpi.engineInit(byArray);
    }

    public final void init(byte[] byArray, String string) throws IOException {
        this.paramSpi.engineInit(byArray, string);
    }

    public final AlgorithmParameterSpec getParameterSpec(Class clazz) throws InvalidParameterSpecException {
        return this.paramSpi.engineGetParameterSpec(clazz);
    }

    public final byte[] getEncoded() throws IOException {
        return this.paramSpi.engineGetEncoded();
    }

    public final byte[] getEncoded(String string) throws IOException {
        return this.paramSpi.engineGetEncoded(string);
    }

    public final String toString() {
        return this.paramSpi.engineToString();
    }

    public static AlgorithmParameters getInstance(String string) throws NoSuchAlgorithmException {
        return AlgorithmParameters.getInstance(Security.getCryptInstance(ENGINE_CLASS, string));
    }

    public static AlgorithmParameters getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        return AlgorithmParameters.getInstance(Security.getCryptInstance(ENGINE_CLASS, string, string2));
    }

    private static AlgorithmParameters getInstance(Security.Engine engine) {
        AlgorithmParametersSpi algorithmParametersSpi = (AlgorithmParametersSpi)engine.getEngine();
        AlgorithmParameters algorithmParameters = new AlgorithmParameters(algorithmParametersSpi, engine.getProvider(), engine.getAlgorithm());
        return algorithmParameters;
    }
}

