/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.Serializable;
import java.net.SocketPermission;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeSource
implements Serializable {
    private URL location;
    private Certificate[] certificates;

    public CodeSource(URL uRL, Certificate[] certificateArray) {
        this.location = uRL;
        this.certificates = certificateArray;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CodeSource codeSource = (CodeSource)object;
        return this.getLocation().equals(codeSource.getLocation()) && this.getCertSet().equals(codeSource.getCertSet());
    }

    public final Certificate[] getCertificates() {
        return this.certificates;
    }

    private Set getCertSet() {
        return new HashSet(Arrays.asList(this.getCertificates()));
    }

    public final URL getLocation() {
        return this.location;
    }

    public int hashCode() {
        return this.getLocation().hashCode() ^ this.getCertSet().hashCode();
    }

    public boolean implies(CodeSource codeSource) {
        if (codeSource == null) {
            return false;
        }
        if (this.getCertificates() != null) {
            if (codeSource.getCertificates() == null) {
                return false;
            }
            if (!codeSource.getCertSet().contains(this.getCertSet())) {
                return false;
            }
        }
        if (this.getLocation() != null) {
            if (codeSource.getLocation() == null) {
                return false;
            }
            if (this.getLocation().equals(codeSource.getLocation())) {
                return true;
            }
            if (!this.getLocation().getProtocol().equals(codeSource.getLocation().getProtocol())) {
                return false;
            }
            if (this.getLocation().getHost() != null && !new SocketPermission(this.getLocation().getHost(), "").implies(new SocketPermission(codeSource.getLocation().getHost(), ""))) {
                return false;
            }
            if (this.getLocation().getPort() != -1 && this.getLocation().getPort() != codeSource.getLocation().getPort()) {
                return false;
            }
            if (!this.getLocation().getFile().equals(codeSource.getLocation().getFile())) {
                String string = this.getLocation().getFile();
                String string2 = codeSource.getLocation().getFile();
                if (string.endsWith("/-") ? !string2.startsWith(string.substring(0, string.length() - 1)) : (string.endsWith("/*") ? !string2.startsWith(string) || string2.lastIndexOf(47) >= string.length() : !string.endsWith("/") && !string2.equals(new StringBuffer().append(string).append('/').toString()))) {
                    return false;
                }
            }
            if (this.getLocation().getRef() != null && !this.getLocation().getRef().equals(codeSource.getLocation().getRef())) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return new StringBuffer().append(this.getClass().getName()).append("[location=").append(this.getLocation()).append(",certificates=").append(this.getCertSet()).append(']').toString();
    }
}

