/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DigestInputStream
extends FilterInputStream {
    protected MessageDigest digest;
    private boolean on = true;

    public DigestInputStream(InputStream inputStream, MessageDigest messageDigest) {
        super(inputStream);
        this.digest = messageDigest;
    }

    public MessageDigest getMessageDigest() {
        return this.digest;
    }

    public void setMessageDigest(MessageDigest messageDigest) {
        this.digest = messageDigest;
    }

    @Override
    public int read() throws IOException {
        int n = this.in.read();
        if (!this.on || n == -1) {
            return n;
        }
        this.digest.update((byte)n);
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (!this.on || n3 == -1) {
            return n3;
        }
        this.digest.update(byArray, n, n3);
        return n3;
    }

    public void on(boolean bl) {
        this.on = bl;
    }

    public String toString() {
        return new StringBuffer().append("DigestInputStream(").append(this.in.toString()).append(", ").append(this.digest.toString()).append(")").toString();
    }
}

