/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyFactory {
    private static final String ENGINE_CLASS = "KeyFactory";
    private KeyFactorySpi keyFacSpi;
    private Provider provider;
    private String algorithm;

    protected KeyFactory(KeyFactorySpi keyFactorySpi, Provider provider, String string) {
        this.keyFacSpi = keyFactorySpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final PublicKey generatePublic(KeySpec keySpec) throws InvalidKeySpecException {
        return this.keyFacSpi.engineGeneratePublic(keySpec);
    }

    public final PrivateKey generatePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        return this.keyFacSpi.engineGeneratePrivate(keySpec);
    }

    public final KeySpec getKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        return this.keyFacSpi.engineGetKeySpec(key, clazz);
    }

    public final Key translateKey(Key key) throws InvalidKeyException {
        return this.keyFacSpi.engineTranslateKey(key);
    }

    public static KeyFactory getInstance(String string) throws NoSuchAlgorithmException {
        return KeyFactory.getInstance(Security.getCryptInstance(ENGINE_CLASS, string));
    }

    public static KeyFactory getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        return KeyFactory.getInstance(Security.getCryptInstance(ENGINE_CLASS, string, string2));
    }

    private static KeyFactory getInstance(Security.Engine engine) {
        KeyFactorySpi keyFactorySpi = (KeyFactorySpi)engine.getEngine();
        KeyFactory keyFactory = new KeyFactory(keyFactorySpi, engine.getProvider(), engine.getAlgorithm());
        return keyFactory;
    }
}

